#
# (C) Tenable Network Security
#

desc["english"] = "
Synopsis :

The remote system can be accessed with a default account. 

Description :

The account 'mpi' on the remote host does not have a password set.  An
attacker may use it to gain further privileges on this system. 

Solution :

Set a strong password for this account or disable it.  This may
disable dependent applications so beware. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

account = "mpi";
password = "";

if(description)
{
 script_id(18527);
 script_version ("$Revision: 1.10 $");
 script_cve_id("CVE-2005-1379");
 script_bugtraq_id(13431);
 
 script_name(english:"Unpassworded 'mpi' account");
 script_description(english:desc["english"]);
 script_summary(english:"Logs into the remote host");

 script_category(ACT_GATHER_INFO);

 script_family(english:"Default Unix Accounts");
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 
 
 script_dependencie("find_service1.nasl", "ssh_detect.nasl");
 script_require_ports("Services/telnet", 23, "Services/ssh", 22);
 exit(0);
}

#
# The script code starts here : 
#
include("default_account.inc");
include("global_settings.inc");

if ( thorough_tests )
{
 port = check_account(login:account, password:password);
 if(port)security_hole(port);
}
