#
#  (C) Tenable Network Security
#


 desc = "
Synopsis :

The remote Windows host has an application that is prone to a buffer
overflow attack. 

Description :

There is a version Adobe Download Manager installed on the remote
Windows host that is vulnerable to a remote buffer overflow attack
because the application fails to perform boundary checks while
processing AOM files.  In order to trigger this issue, an attacker
needs to entice a user to visit a website hosting the malicious AOM
file or send the AOM file as an email attachment and have the user
click on it.  Successful exploitation of this issue might result in
arbitrary code execution. 

See also :

http://research.eeye.com/html/advisories/published/AD20061205.html
http://archives.neohapsis.com/archives/fulldisclosure/2006-12/0092.html
http://www.adobe.com/support/security/bulletins/apsb06-19.html

Solution :

Either uninstall the application or upgrade to Adobe Download Manager
version 2.2 or later. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";


if (description) {
  script_id(23779);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2006-5856");
  script_bugtraq_id(21453);
  script_xref(name:"OSVDB", value:"31055");

  script_name(english:"Adobe Download Manager Detection");
  script_summary(english:"Checks for Adobe Download Manager version < 2.2"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");
  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139,445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");

function display_dword (dword, nox)
{
 local_var tmp;

 if (isnull(nox) || (nox == FALSE))
   tmp = "0x";
 else
   tmp = "";

 return string (tmp,
               toupper(
                  hexstr(
                    raw_string(
                               (dword >>> 24) & 0xFF,
                               (dword >>> 16) & 0xFF,
                               (dword >>> 8) & 0xFF,
                               dword & 0xFF
                              )
                        )
                      )
               );
}

function compute_version(ver)
{
  local_var version, array, index, i;

  array = split(ver,sep:".",keep:FALSE);
  index = max_index(array)-1;
  for (i = 0 ; i < max_index(array) ; i++){
    version += array[i] * (10**index);
    index--;
  }
  return version;
}

function check_version1(cv,lv)
{
  local_var current_version,result,array, i;

  if (compute_version(ver:cv) < compute_version(ver:lv)) return FALSE;
  else return TRUE;		
}


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) {
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm)) {
  NetUseDel();
  exit(0);
}


# Determine where it's installed.
key = "SOFTWARE\Classes\aom\DefaultIcon";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);

if (!isnull(key_h)) {
  value = RegQueryValue(handle:key_h, item:NULL);
  if (isnull(value)) exit(0);
  else {
    # nb: the value may appear in quotes.
    exe = ereg_replace(pattern:'"(.+)",[0-9]', replace:"\1", string:value[1]);
  }
  RegCloseKey (handle:key_h);
}
RegCloseKey(handle:hklm);


# If it is...
if (exe) {
  # Determine its version from the executable itself.
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exe);
  exe2 =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exe);
  NetUseDel(close:FALSE);

  rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
  if (rc != 1) {
    NetUseDel();
    exit(0);
  }

  fh = CreateFile(
    file:exe2,
    desired_access:GENERIC_READ,
    file_attributes:FILE_ATTRIBUTE_NORMAL,
    share_mode:FILE_SHARE_READ,
    create_disposition:OPEN_EXISTING
  );

  ver = NULL;
  if (!isnull(fh)) {
    ret = GetFileVersionEx(handle:fh);

    if (!isnull(ret)) children = ret['Children'];
    if (!isnull(children))
    {
      varfileinfo = children['VarFileInfo'];
      if (!isnull(varfileinfo))
      {
        translation = 
          (get_word (blob:varfileinfo['Translation'], pos:0) << 16) +
          get_word (blob:varfileinfo['Translation'], pos:2);
        translation = tolower(display_dword(dword:translation, nox:TRUE));
      }
      stringfileinfo = children['StringFileInfo'];
      if (!isnull(stringfileinfo) && !isnull(translation))
      {
        data = stringfileinfo[translation];
        if (!isnull(data)) ver = data['ProductVersion'];
      }
    }
    CloseFile(handle:fh);
  }

  # Check the verion number, if it's available.
  if (!isnull(ver))
  {
    if (!check_version1(cv:ver, lv:"2.2"))
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Version ", ver, " of Adobe Download Manager is installed as :\n",
        "  ", exe
      );
      security_warning(port:kb_smb_transport(), data:report);
    }
  }
}


# Clean up.
NetUseDel();
