#
# (C) Tenable Network Security
#


if (description) {
  script_id(22361);
  script_version("$Revision: 1.3 $");

  script_name(english:"ColdFusion MX Server Detection");
  script_summary(english:"Detects a ColdFusion MX server");

  desc = "
Synopsis :

The remote host is running an application server. 

Description :

The remote host is running Macromedia ColdFusion MX, a commercial
application server and web site development framework.

See also :

http://www.adobe.com/products/coldfusion

Risk factor : 

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");

  script_dependencies("find_service2.nasl");
  script_require_ports("Services/unknown", 2901, 2920);

  exit(0);
}


include ('byte_func.inc');
include("global_settings.inc");
include("misc_func.inc");


if (thorough_tests && ! get_kb_item("global_settings/disable_service_discovery") ) {
  port = get_unknown_svc(2920);
  if (!port) exit(0);
  ports = make_list(port);
}
else ports = make_list (2920, 2901);

foreach port (ports)
{
 if ( ! get_port_state(port) ) continue;
 soc = open_sock_tcp (port);
 if (!soc)
   continue;

 data = '\xac\xed\x00\x05';

 data += raw_string (
	0x73, 0x72, 0x00, 0x19, 0x6A, 0x61, 0x76, 0x61, 0x2E, 0x72, 0x6D, 0x69, 0x2E, 0x4D, 0x61, 0x72, 
	0x73, 0x68, 0x61, 0x6C, 0x6C, 0x65, 0x64, 0x4F, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x7C, 0xBD, 0x1E, 
	0x97, 0xED, 0x63, 0xFC, 0x3E, 0x02, 0x00, 0x03, 0x49, 0x00, 0x04, 0x68, 0x61, 0x73, 0x68, 0x5B, 
	0x00, 0x08, 0x6C, 0x6F, 0x63, 0x42, 0x79, 0x74, 0x65, 0x73, 0x74, 0x00, 0x02, 0x5B, 0x42, 0x5B, 
	0x00, 0x08, 0x6F, 0x62, 0x6A, 0x42, 0x79, 0x74, 0x65, 0x73, 0x71, 0x00, 0x7E, 0x00, 0x01, 0x78, 
	0x70, 0xFB, 0xF2, 0x0F, 0xD3, 0x70, 0x75, 0x72, 0x00, 0x02, 0x5B, 0x42, 0xAC, 0xF3, 0x17, 0xF8, 
	0x06, 0x08, 0x54, 0xE0, 0x02, 0x00, 0x00, 0x78, 0x70, 0x00, 0x00, 0x01, 0x29, 0xAC, 0xED, 0x00, 
	0x05, 0x73, 0x72, 0x00, 0x14, 0x6A, 0x61, 0x76, 0x61, 0x2E, 0x75, 0x74, 0x69, 0x6C, 0x2E, 0x50, 
	0x72, 0x6F, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x39, 0x12, 0xD0, 0x7A, 0x70, 0x36, 0x3E, 
	0x98, 0x02, 0x00, 0x01, 0x4C, 0x00, 0x08, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6C, 0x74, 0x73, 0x74, 
	0x00, 0x16, 0x4C, 0x6A, 0x61, 0x76, 0x61, 0x2F, 0x75, 0x74, 0x69, 0x6C, 0x2F, 0x50, 0x72, 0x6F, 
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x3B, 0x78, 0x72, 0x00, 0x13, 0x6A, 0x61, 0x76, 0x61, 
	0x2E, 0x75, 0x74, 0x69, 0x6C, 0x2E, 0x48, 0x61, 0x73, 0x68, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x13, 
	0xBB, 0x0F, 0x25, 0x21, 0x4A, 0xE4, 0xB8, 0x03, 0x00, 0x02, 0x46, 0x00, 0x0A, 0x6C, 0x6F, 0x61, 
	0x64, 0x46, 0x61, 0x63, 0x74, 0x6F, 0x72, 0x49, 0x00, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 
	0x6F, 0x6C, 0x64, 0x78, 0x70, 0x3F, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x77, 0x08, 0x00, 
	0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x03, 0x74, 0x00, 0x18, 0x6A, 0x61, 0x76, 0x61, 0x2E, 0x6E, 
	0x61, 0x6D, 0x69, 0x6E, 0x67, 0x2E, 0x70, 0x72, 0x6F, 0x76, 0x69, 0x64, 0x65, 0x72, 0x2E, 0x75, 
	0x72, 0x6C, 0x74, 0x00, 0x12, 0x31, 0x37, 0x32, 0x2E, 0x32, 0x30, 0x2E, 0x31, 0x30, 0x31, 0x2E, 
	0x37, 0x35, 0x3A, 0x32, 0x39, 0x32, 0x30, 0x74, 0x00, 0x1B, 0x6A, 0x61, 0x76, 0x61, 0x2E, 0x6E, 
	0x61, 0x6D, 0x69, 0x6E, 0x67, 0x2E, 0x66, 0x61, 0x63, 0x74, 0x6F, 0x72, 0x79, 0x2E, 0x69, 0x6E, 
	0x69, 0x74, 0x69, 0x61, 0x6C, 0x74, 0x00, 0x1E, 0x6A, 0x72, 0x75, 0x6E, 0x2E, 0x6E, 0x61, 0x6D, 
	0x69, 0x6E, 0x67, 0x2E, 0x4A, 0x52, 0x75, 0x6E, 0x43, 0x6F, 0x6E, 0x74, 0x65, 0x78, 0x74, 0x46, 
	0x61, 0x63, 0x74, 0x6F, 0x72, 0x79, 0x74, 0x00, 0x14, 0x6A, 0x72, 0x75, 0x6E, 0x2E, 0x6E, 0x61, 
	0x6D, 0x69, 0x6E, 0x67, 0x2E, 0x72, 0x65, 0x61, 0x64, 0x4F, 0x6E, 0x6C, 0x79, 0x74, 0x00, 0x04, 
	0x74, 0x72, 0x75, 0x65, 0x78, 0x70
 );

 send (socket:soc, data:data);
 buf = recv (socket:soc, length:4096);

 close (soc);

 if (!buf || (strlen(buf) < 8))
   continue;

 if ( (getdword (blob:buf, pos:0) == 0xaced0005) &&
      (getword (blob:buf, pos:4) == 0x7372) &&
      ("java.rmi.server.RemoteObject" >< buf) )
 {
  register_service(port:port, ipproto:"tcp", proto:"coldfusion");
  security_note (port);
 }
}
