#
#  (C) Tenable Network Security
#


if (description)
{
  script_id(20836);
  script_version("$Revision: 1.9 $");

  script_name(english:"Adobe Reader Detection");
  script_summary(english:"Checks for Adobe Reader"); 
 
 desc = "
Synopsis :

There is a PDF file viewer installed on the remote Windows host. 

Description :

Adobe Reader, a PDF file viewer, is installed on the remote host. 

See also :

http://www.adobe.com/products/acrobat/readermain.html

Risk factor : 

None";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");


function display_dword (dword, nox)
{
 local_var tmp;

 if (isnull(nox) || (nox == FALSE))
   tmp = "0x";
 else
   tmp = "";

 return string (tmp,
               toupper(
                  hexstr(
                    raw_string(
                               (dword >>> 24) & 0xFF,
                               (dword >>> 16) & 0xFF,
                               (dword >>> 8) & 0xFF,
                               dword & 0xFF
                              )
                        )
                      )
               );
}


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) 
{
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm)) 
{
  NetUseDel();
  exit(0);
}


# Determine where it's installed.
path = NULL;
min = NULL;
max = NULL;

# - nb: this works for recent versions of Adobe Reader.
key = "SOFTWARE\Adobe\Acrobat Reader";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  info = RegQueryInfoKey(handle:key_h);
  for (i=0; i<info[1]; ++i)
  {
    subkey = RegEnumKey(handle:key_h, index:i);
    if (strlen(subkey) && subkey =~ "^[0-9.]+$")
    {
      key2 = key + "\" + subkey + "\Installer";
      key2_h = RegOpenKey(handle:hklm, key:key2, mode:MAXIMUM_ALLOWED);
      if (!isnull(key2_h))
      {
        value = RegQueryValue(handle:key2_h, item:"VersionMax");
        if (!isnull(value)) max = int(value[1]);

        value = RegQueryValue(handle:key2_h, item:"VersionMin");
        if (!isnull(value)) min = int(value[1]);

        value = RegQueryValue(handle:key2_h, item:"Path");
        if (!isnull(value)) path = ereg_replace(pattern:"^(.+)\\$", replace:"\1", string:value[1]);

        RegCloseKey(handle:key2_h);
      }
    }
  }
  RegCloseKey (handle:key_h);
}
# - nb: this works for Acrobat Reader 5.x
if (isnull(path))
{
  key = "SOFTWARE\Classes\Software\Adobe\Acrobat\Exe";
  key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
  if (!isnull(key_h))
  {
    value = RegQueryValue(handle:key_h, item:NULL);
    if (!isnull(value)) 
    {
      # nb: the value may appear in quotes.
      exe = ereg_replace(pattern:'^"(.+)"', replace:"\1", string:value[1]);
      if ("AcroRd32" >< exe) path = exe - "\Reader\AcroRd32.exe";
    }

    RegCloseKey (handle:key_h);
  }
}
RegCloseKey(handle:hklm);
if (isnull(path))
{
  NetUseDel();
  exit(0);
}


# Determine its version from the executable itself.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
exe =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\Reader\AcroRd32.exe", string:path);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:exe,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
ver = NULL;
if (!isnull(fh))
{
  ret = GetFileVersionEx(handle:fh);
  if (!isnull(ret)) children = ret['Children'];
  if (!isnull(children))
  {
    varfileinfo = children['VarFileInfo'];
    if (!isnull(varfileinfo))
    {
      translation = 
        (get_word (blob:varfileinfo['Translation'], pos:0) << 16) +
        get_word (blob:varfileinfo['Translation'], pos:2);
      translation = toupper(display_dword(dword:translation, nox:TRUE));
    }
    stringfileinfo = children['StringFileInfo'];
    if (!isnull(stringfileinfo) && !isnull(translation))
    {
      data = stringfileinfo[translation];
      if (!isnull(data)) ver = data['ProductVersion'];
    }
  }
  CloseFile(handle:fh);
}


# Get the version from AcroRd32.dll for versions 8.1.x.
if (ver =~ "^8\.1\.0\.")
{
  dll =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\Reader\AcroRd32.dll", string:path);
  fh = CreateFile(
    file:dll,
    desired_access:GENERIC_READ,
    file_attributes:FILE_ATTRIBUTE_NORMAL,
    share_mode:FILE_SHARE_READ,
    create_disposition:OPEN_EXISTING
  );
  ver = NULL;
  if (!isnull(fh))
  {
    ret = GetFileVersionEx(handle:fh);
    if (!isnull(ret)) children = ret['Children'];
    if (!isnull(children))
    {
      varfileinfo = children['VarFileInfo'];
      if (!isnull(varfileinfo))
      {
        translation = 
          (get_word (blob:varfileinfo['Translation'], pos:0) << 16) +
          get_word (blob:varfileinfo['Translation'], pos:2);
        translation = toupper(display_dword(dword:translation, nox:TRUE));
      }
      stringfileinfo = children['StringFileInfo'];
      if (!isnull(stringfileinfo) && !isnull(translation))
      {
        data = stringfileinfo[translation];
        if (!isnull(data)) ver = data['ProductVersion'];
      }
    }
    CloseFile(handle:fh);
  }
}

# Save and report the version number and installation path.
if (!isnull(ver) && !isnull(path))
{
  # 7.0.9 is a special case.
  if (ver =~ "^7\.0\.8\." && max && min && max == 7 && min == 9)
  {
    ver = "7.0.9";
  }

  set_kb_item(name:"SMB/Acroread/Path", value:path);
  set_kb_item(name:"SMB/Acroread/Version", value:ver);

  # Reformat the version based on how it's displayed in 
  # the Help, About menu pull-down.
  pat = "^([0-9]+\.[0-9]+\.[0-9])\.(2[0-9]{3})([0-9]{2})([0-9]{2})([0-9]{2})$";
  v = eregmatch(pattern:pat, string:ver);
  if (!isnull(v))
  {
    if (ver =~ "^[0-6]\.")
    {
      ver = string(v[1], " ", int(v[3]), "/", int(v[4]), "/", int(v[2]));
    }
    else
    {
      ver = v[1];
    }
  }

  report = string(
    "\n",
    "Version ", ver, " of Adobe Reader is installed under :\n",
    "\n",
    "  ", path, "\n"
  );

  security_note(port:port, extra:report);
}


# Clean up.
NetUseDel();
