#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28504);
 script_version ("$Revision: 1.1 $");
 name["english"] = "AIX 530004 : U805087";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is missing a vendor supplied security patch

Description :

The remote host is missing AIX PTF U805087 which is related
to the security of the package devices.pci.77102224.com

You should install this PTF for your system to be up-to-date.

Solution : 

Run 'suma -x -a RqType=Security' on the remote system

Risk factor : 

High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for PTF U805087"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "AIX Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/AIX/lslpp");
 exit(0);
}



include("aix.inc");

if ( aix_check_patch(ml:"530004", patch:"U805087", package:"devices.pci.77102224.com.5.3.0.3") < 0 ) 
  security_hole(port:0, extra:aix_report_get());
