#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(28804);
 script_version ("$Revision: 1.1 $");
 name["english"] = "AIX 520009 : U810133";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is missing a vendor supplied security patch

Description :

The remote host is missing AIX PTF U810133 which is related
to the security of the package devices.iscsi_sw.rte

You should install this PTF for your system to be up-to-date.

Solution : 

Run 'suma -x -a RqType=Security' on the remote system

Risk factor : 

High";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for PTF U810133"; 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "AIX Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/AIX/lslpp");
 exit(0);
}



include("aix.inc");

if ( aix_check_patch(ml:"520009", patch:"U810133", package:"devices.iscsi_sw.rte.5.2.0.97") < 0 ) 
  security_hole(port:0, extra:aix_report_get());
