#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

A deployment service is listening on the remote host. 

Description :

The remote service is running the Deployment Server component of
Altiris Deployment Solution, a product for centralized management of
computer systems throughout an enterprise. 

See also :

http://www.altiris.com/Products/DeploymentSolution.aspx

Solution :

Limit incoming traffic to this port if desired. 

Risk factor :

None";


if (description)
{
  script_id(25897);
  script_version("$Revision: 1.4 $");

  script_name(english:"Altiris Deployment Server Detection");
  script_summary(english:"Tries to detect Alteris Deployment Server");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/unknown", 402);

  exit(0);
}


include("byte_func.inc");
include("global_settings.inc");
include("misc_func.inc");


if (thorough_tests && !get_kb_item("global_settings/disable_service_discovery") )
{
  port = get_unknown_svc(402);
  if (!port) exit(0);
}
else port = 402;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Send a request.
name = SCRIPT_NAME;
req = 
  'Request=SmartUpdate\n' +
    'ID=1\n' +
    'MAC-Address=00132003bd94\n' +
    'Name=' + name + '\n' +
    'Domain-Member=No\n' +
    'IP-Address=' + this_host() + '\n' +
    'Computer-Name=NESSUS\n' +
  mkbyte(0);
send(socket:soc, data:req);
res = recv(socket:soc, length:1024);
close(soc);


# If it looks like a valid reply...
if (
  "Reply=SmartUpdate" >< res &&
  "Result=" >< res
)
{
  # Extract some interesting info for the report.
  info = "";
  # - server name.
  if ("Server-Name=" >< res)
  {
    name = strstr(res, "Server-Name=") - "Server-Name=";
    name = name - strstr(name, '\n');
    if (strlen(name))
    {
      info += "  Server name : " + name + '\n';
    }
  }
  # - Deployment Server version.
  if ("DSVersion=" >< res)
  {
    ver = strstr(res, "DSVersion=") - "DSVersion=";
    ver = ver - strstr(ver, '\n');
    if (ver =~ "^[0-9][0-9.]+$")
    {
      set_kb_item(name:"Altiris/DSVersion/"+port, value:ver);
      info += "  Version     : " + ver + '\n';
    }
  }

  # Register and report the service.
  register_service(port:port, ipproto:"tcp", proto:"axengine");

  if (info)
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Nessus was able to gather the following information from the remote\n",
      "Altiris Deployment Server :\n",
      "\n",
      info
    );
  else report = desc;
  security_note(port:port, data:report);
}
