#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server may be affected by one or more issues. 

Description :

According to its banner, the version of Apache 2.2 installed on the
remote host is older than 2.2.6.  Such versions may be affected by
several issues, including :

  - A denial of service vulnerability in mod_proxy. 
  - A cross-site scripting vulnerability in mod_status.
  - A local denial of service vulnerability associated with
    the Prefork MPM module.
  - An information leak in mod_cache.
  - A denial of service vulnerability in mod_cache.

In addition, it offers a workaround for a cross-site scripting issue
in mod_autoindex. 

Note that the remote web server may not actually be affected by these
vulnerabilities.  Nessus did not try to determine whether any of the
affected modules are in use on the remote server or to check for the
issues themselves.

See also :

http://www.apache.org/dist/httpd/CHANGES_2.2.6

Solution :

Either ensure that the affected modules are not in use or configured
so as to avoid the issues or upgrade to Apache version 2.2.6 or later. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";


if (description)
{
  script_id(26023);
  script_version("$Revision: 1.5 $");

  script_cve_id(
    "CVE-2006-5752",
    "CVE-2007-1862",
    "CVE-2007-1863",
    "CVE-2007-3303",
    "CVE-2007-3304",
    "CVE-2007-3847",
    "CVE-2007-4465"
  );
  script_bugtraq_id(24215, 24553, 24645, 24649, 25489, 25653);

  script_name(english:"Apache < 2.2.6 Multiple Vulnerabilities");
  script_summary(english:"Checks version in Server response header");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_keys("www/apache");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("backport.inc");
include("global_settings.inc");
include("http_func.inc");


# nb: banner checks of Apache are prone to false-positives so we only
#     run the check if reporting is paranoid.
if (report_paranoia < 2) exit(0);


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


banner = get_backport_banner(banner:get_http_banner(port:port));
if (banner && "Server:" >< banner)
{
  server = strstr(banner, "Server:");

  pat = "^Server:.*Apache(-AdvancedExtranetServer)?/([0-9]+\.[^ ]+)";
  ver = NULL;
  matches = egrep(pattern:pat, string:server);
  if (matches)
  {
    foreach match (split(matches))
    {
      match = chomp(match);
      ver = eregmatch(pattern:pat, string:match);
      if (!isnull(ver))
      {
        ver = ver[2];
        break;
      }
    }
  }

  if (!isnull(ver) && ver =~ "^2\.2\.[0-5]$")
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "According to its banner, Apache version ", ver, " is installed on the\n",
      "remote host.\n"
    );
    security_warning(port:port, data:report);
   }
}
