#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24015);
  script_version("$Revision: 1.3 $");

  script_cve_id(
    "CVE-2006-5171",
    "CVE-2006-5172",
    "CVE-2006-6076",
    "CVE-2006-6917",
    "CVE-2007-0168",
    "CVE-2007-0169"
  );
  script_bugtraq_id(21221, 22005, 22006, 22010, 22015, 22016);
  script_xref(name:"OSVDB", value:"30637");
  script_xref(name:"OSVDB", value:"31319");
  script_xref(name:"OSVDB", value:"31320");
  script_xref(name:"OSVDB", value:"31327");

  script_name(english:"BrightStor ARCserve Multiple Vulnerabilities");
  script_summary(english:"Checks version of BrightStor ARCserve Backup");

  desc = "
Synopsis :

The remote software is affected by multiple vulnerabilities. 

Description :

According to its version, the installation of BrightStor ARCserve
Backup on the remote host is affected by multiple buffer overflows
that can be exploited by an unauthenticated remote attacker to execute
arbitrary code on the affected host with SYSTEM privileges. 

See also : 

http://www.lssec.com/advisories/LS-20060908.pdf
http://www.lssec.com/advisories/LS-20061001.pdf
http://www.securityfocus.com/archive/1/456711/30/0/threaded
http://supportconnectw.ca.com/public/storage/infodocs/babimpsec-notice.asp

Solution :

Apply the appropriate patch as described in the vendor advisory
referenced above. 

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");
 
  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");
 
  script_dependencies("arcserve_discovery_service_detect.nasl");
  script_require_keys("ARCSERVE/Discovery/Version");

  exit(0);
}


include("misc_func.inc");


ver = get_kb_item("ARCSERVE/Discovery/Version");
if (isnull(ver)) exit(0);


matches = eregmatch(string:ver, pattern:"^[a-z]([0-9]+\.[0-9]+) \(build ([0-9]+)\)$");
if (!isnull(matches))
{
  ver = matches[1];
  build = int(matches[2]);

  if (
    (ver == "11.5" && build < 4235) ||
    (ver == "11.1" && build < 3207) ||
    # nb: QI82917 says there's no patch for 11.0; the solution is to 
    #     upgrade to 11.1 and then apply QO84984.
    (ver == "11.0") ||
    # nb: QO84986 doesn't exist.
    (ver == "10.5") ||
    (ver == "9.0" && build < 2204)
  )
  {
    # Issue a report for each open TCP port.
    tcp_ports = make_list(
      111,                             # Mediasvr service
      6502,                            # Tape Engine
      6503,                            # Message Engine
      6504                             # Message Engine
    );
    foreach port (tcp_ports)
    {
      # Make sure the port is open.
      if (get_port_state(port) && !known_service(port:port))
      {
        soc = open_sock_tcp(port);
        if (soc)
        {
          close(soc);
          security_hole(port);
        }
      }
    }
    udp_ports = make_list(
      111                              # Mediasvr service
    );
    foreach port (udp_ports)
    {
      security_hole(port:port, proto:"udp");
    }
  }
}
