#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
#

if(description)
{
 script_id(10362);
 script_bugtraq_id(149);
 script_version ("$Revision: 1.22 $");
 script_cve_id("CVE-1999-0278"); 

 name["english"] = "ASP source using ::$DATA trick";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is affected by an information disclosure flaw. 

Description :

It is possible to get the source code of a remote ASP script by
appending '::$DATA' to the end of the request.  ASP source code
usually contains sensitive information such as logins and passwords. 

See also :

http://www.microsoft.com/technet/security/bulletin/ms98-003.mspx

Solution :

Apply the hotfixes referenced in the vendor advisory above. 
	
Risk factor : 

Low / CVSS Base Score : 1
(AV:R/AC:L/Au:R/C:P/A:N/I:N/B:N)";
 script_description(english:desc["english"]);
 
 summary["english"] = "downloads the source of ASP scripts";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 2000 Renaud Deraison");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencies("find_service1.nasl", "webmirror.nasl", "http_version.nasl", "www_fingerprinting_hmap.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#
include("http_func.inc");
include("http_keepalive.inc");

function check(file)
{
  local_var req, r;

  req = http_get(item:string(file, "::$DATA"), port:port);
  r = http_keepalive_send_recv(port:port, data:req);
  if  ( ! r ) exit(0);
  if(
    "Content-Type: application/octet-stream" >< r && 
    "<%" >< r && 
    "Bad Request" >!< r 
  ) {
    security_note(port);
    return(1);
  }
  return(0);
}


port = get_http_port(default:80);
if ( ! can_host_asp(port:port) ) exit(0);

if(get_port_state(port))
{
 if(check(file:"/default.asp"))exit(0);
 files = get_kb_list(string("www/", port, "/content/extensions/asp"));
 if(isnull(files))exit(0);
 files = make_list(files);
 check(file:files[0]); 
}
