# Written by Gareth M. Phillips - SensePost PTY ltd
# www.sensepost.com


desc["english"] = "
Synopsis :

The remote web server allows access to its usage reports. 

Descriptions :

The remote web server is running a version of AWStats that seems to be
accessible to the entire Internet.  Exposing AWStats unprotected to
the entire Internet will aid an attacker in gaining further knowledge
of web server and contents there in.  An attacker may gain access to
administrative backends or private files hosted on the server. 

Solution :

AWStats should be either restricted to authorised networks/hosts only,
or protected with some form of Basic-Auth. 

Risk factor :

None";


if (description) {
script_id(26056);
script_version("$Revision: 1.1 $");


name["english"] = "AWStats is Openly Accessible";
script_name(english:name["english"]);

summary["english"] = "AWStats seems to be openly accessible to any user";
script_summary(english:summary["english"]);

script_description(english:desc["english"]);

script_category(ACT_GATHER_INFO);
script_family(english:"CGI abuses");

script_copyright(english:"This script is Copyright (C) 2007 SensePost");

script_require_ports("Services/www", 80);
script_exclude_keys("Settings/disable_cgi_scanning");

exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);

dirs = get_kb_list(string("www/", port, "content/directories"));
if(isnull(dirs))dirs = make_list("", "/stats", "/awstats");
dirs = make_list(dirs, cgi_dirs());

info = '';
foreach d (dirs)
        {
        # Trying to retrieve the AWStats default File.
        url = d+"/awstats.pl";
        req = http_get(item:url, port:port);
        res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
        if (res == NULL) exit(0);
if(egrep(pattern:"^HTTP.* 401 .*", string:res)) exit(0);
        if ('src="awstats.pl?framename=mainleft' >< res || egrep(pattern:'content="[aA]wstats - Advanced Web Statistics', string:res))
                {
                info += ' ' + url + '\n';
                if (!thorough_tests) break;
                }
}

if (info)
        {
         report = string(
                desc["english"],
                "\n\n",
                "Plugin output : \n",
                "\n",
                "AWStats' default page, awstats.pl, was found to exist on the web\n",
                "server under the following URL(s) :\n",
                "\n",
                info
                );
        security_note(port:port, data:report); exit(0);
}
