#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(28361);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-4346", "CVE-2007-4347");
  script_bugtraq_id(26028, 26029);

  script_name(english:"Symantec Backup Exec for Windows Servers Denial of Service Vulnerabilities");
  script_summary(english:"Checks version of bengine.exe");
 
 desc = "
Synopsis :

The remote Windows host contains an application that is affected by
several denial of service vulnerabilities. 
 
Description :

Backup Exec for Windows Servers, a commercial backup product from
Symantec, is installed on the remote host. 

The version of the Backup Exec Job Engine, bengine.exe, installed as
part of Backup Exec for Windows Server on the remote host contains a
null-pointer dereference error when handling exceptions.  Using a
specially-crafted packet, an attacker can leverage this issue to crash
the affected service. 

In addition, it is affected by two overflow errors that can cause the
service to enter an infinite loop, resulting in high CPU utilization
and/or memory exhaustion. 

See also :

http://secunia.com/secunia_research/2007-74/advisory/
http://www.securityfocus.com/archive/1/484318/30/0/threaded
http://support.veritas.com/docs/294241
http://support.veritas.com/docs/294237
http://www.securityfocus.com/archive/1/484333/30/0/threaded

Solution :

Apply the appropriate hotfix according to the vendor advisories above. 

Risk factor : 

High / CVSS Base Score : 7.8
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:C)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");
include("smb_hotfixes.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Connect to the appropriate share.
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1) {
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Make sure it's installed.
path = NULL;

key = "SOFTWARE\Symantec\Backup Exec for Windows\Backup Exec\11.0\Install";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:"Path");
  if (!isnull(value))
  {
    path = value[1];
    path = ereg_replace(pattern:"^(.+)\\$", replace:"\1", string:path);
  }

  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
if (isnull(path))
{
  NetUseDel();
  exit(0);
}


# Grab the file version of the affected file.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
exe = ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\bengine.exe", string:path);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:exe,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
ver = NULL;
if (!isnull(fh))
{
  ver = GetFileVersion(handle:fh);
  CloseFile(handle:fh);
}
NetUseDel();


# Check the version number.
if (!isnull(ver) && 11 == ver[0] && 0 == ver[1])
{
  if (7170 == ver[2]) fix = "11.0.7170.25";
  else if (6235 == ver[2]) fix = "11.0.6235.29";
  else exit(0);

  fix = split(fix, sep:'.', keep:FALSE);
  for (i=0; i<4; i++)
    fix[i] = int(fix[i]);

  for (i=0; i<max_index(ver); i++)
    if ((ver[i] < fix[i]))
    {
      security_hole(port);
      break;
    }
    else if (ver[i] > fix[i])
      break;
}
