# bigip_web_detect.nasl
#
# History:
#
# 1.00, 12/13/07
# - Initial release


if (description)
    {
    script_id(30215);
    script_version("$Revision: 1.2 $");
    name["english"]="F5 BIG-IP web management interface detection";
    desc["english"]="
Synopsis :

The remote web server is a web management interface. 

Description :

An F5 BIG-IP web management interface is running on this port. 

See also :

http://www.f5.com/products/big-ip/

Solution :

Filter incoming traffic to this port, possibly using bigpipe command
'httpd allow ....  For regular, non-management network ports, the
traffic can be also restricted with BIG-IP stateful packet filters. 

Risk factor :

None";
    summary["english"]="Detects F5 BIG-IP web management interface";
    family["english"]="Web Servers";
    script_name(english:name["english"]);
    script_description(english:desc["english"]);
    script_summary(english:summary["english"]);
    script_family(english:family["english"]);
    script_category(ACT_GATHER_INFO);
    script_copyright(english:"This script is Copyright (c) 2007-2008 nnposter");
    script_dependencies("find_service1.nasl","httpver.nasl");
    script_require_ports("Services/www",443);
    exit(0);
    }


include("http_func.inc");
include("http_keepalive.inc");
include("misc_func.inc");


port = get_http_port(default:443);
if (!get_tcp_port_state(port)) exit(0);
resp = http_keepalive_send_recv(port:port, data:http_get(item:"/",port:port), embedded:TRUE);
if (!resp) exit(0);

if ( egrep(pattern:"<title>BIG-IP[^<]*</title>",string:resp,icase:TRUE) &&
     "tmui/tmui/system/settings/redirect.jsp" >< resp )
{
 replace_or_set_kb_item(name:"www/bigip",value:TRUE);
 replace_or_set_kb_item(name:"www/"+port+"/bigip",value:TRUE);
 replace_or_set_kb_item(name:"Services/www/"+port+"/embedded",value:TRUE);
 security_note(port);
}
