#
# This script is (c) Tenable Network Security
#


if(description)
{
 script_id(16261);
 script_bugtraq_id(12365, 12497);
 script_version ("$Revision: 1.7 $");
 script_cve_id("CVE-2005-0034");
 
 name["english"] = "BIND Validator Self Checking Remote Denial Of Service Vulnerability";
 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

The remote name server is prone to a denial of service attack.

Description :

The remote bind server, according to its version number, has a flaw in
the way 'authvalidator()' is implemented. 

Provided DNSSEC has been enabled in the remote name server, an
attacker may be able to launch a denial of service attack against the
remote service. 

See also :

http://www.kb.cert.org/vuls/id/938617
http://www.isc.org/index.pl?/sw/bind/bind-security.php

Solution : 

Upgrade to bind 9.3.1 or later.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:N/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks the remote BIND version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);

 script_dependencie("bind_version.nasl");
 script_require_keys("bind/version");
 exit(0);
}

include('global_settings.inc');

if (report_paranoia < 1) exit(0);	# FP on Mandrake

vers = string(get_kb_item("bind/version"));
if(!vers)exit(0);

if (ereg(string:vers, pattern:"^9\.3\.0$"))
  security_warning(port: 53, proto: 'udp');
