#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote host has an anti-virus software package installed on it. 

Description :

The remote host is running BitDefender, a commercial anti-virus
software package for Windows. 

See also :

http://www.bitdefender.com/

Risk factor :

None";


if (description)
{
  script_id(24232);
  script_version("$Revision: 1.133 $");

  script_name(english:"BitDefender Check");
  script_summary(english:"Checks for BitDefender");
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("smb_enum_services.nasl", "smb_hotfixes.nasl");
  script_require_keys("SMB/name", "SMB/login", "SMB/password", "SMB/registry_full_access", "SMB/transport");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");


# Connect to the remote registry.
if (!get_kb_item("SMB/registry_full_access")) exit(0);


name    = kb_smb_name();
if (!name) exit(0);
login   = kb_smb_login();
pass    = kb_smb_password();
domain  = kb_smb_domain();
port    = kb_smb_transport();
if (!port) port = 139;
if (!get_port_state(port)) exit(0);

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1)
{
  exit(0);
}

hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Grab the paths for the software itself as well as the virus signatures.
path1 = NULL;
path2 = NULL;
key1 = "SOFTWARE\Softwin\BitDefender Desktop\Maintenance\Install";
key1_h = RegOpenKey(handle:hklm, key:key1, mode:MAXIMUM_ALLOWED);
if (!isnull(key1_h))
{
  value = RegQueryValue(handle:key1_h, item:"InstallDir");
  if (!isnull(value))
  {
    path1 = value[1];
    path1 = ereg_replace(pattern:"(.*)\\", replace:"\1", string:path1);

    key2 = "SOFTWARE\Softwin";
    key2_h = RegOpenKey(handle:hklm, key:key2, mode:MAXIMUM_ALLOWED);
    if (!isnull(key2_h))
    {
      value = RegQueryValue(handle:key2_h, item:"BitDefender Scan Server");
      if (!isnull(value))
      {
        path2 = value[1];
        path2 = ereg_replace(pattern:"(.*)\\", replace:"\1", string:path2);
      }

      RegCloseKey (handle:key2_h);
    }
  }
  RegCloseKey (handle:key1_h);

}
RegCloseKey(handle:hklm);
if (isnull(path1) || isnull(path2))
{
  NetUseDel();
  exit(0);  
}
set_kb_item(name:"Antivirus/BitDefender/installed", value:TRUE);
set_kb_item(name:"Antivirus/BitDefender/Path", value:path1);


# Pull info about the virus signatures and engine.
name = "unknown";
ver = "unknown";
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path1);
file =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\status.ini", string:path1);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc == 1)
{
  fh = CreateFile(
    file:file,
    desired_access:GENERIC_READ,
    file_attributes:FILE_ATTRIBUTE_NORMAL,
    share_mode:FILE_SHARE_READ,
    create_disposition:OPEN_EXISTING
  );
  if (!isnull(fh))
  {
    contents = ReadFile(handle:fh, offset:0, length:10240);
    lines = split(contents, keep:FALSE);
    foreach line (lines)
    {
      if ("IDS_BITDEFENDER_PROF" >< line) 
      {
        name = ereg_replace(pattern:'^.+[ \t]*=[ \t]*"(.+)"$', replace:"\1", string:line);
        set_kb_item(name:"Antivirus/BitDefender/Product", value:name);
      }
      else if ("IDS_BUILD_PROF" >< line) 
      {
        ver = ereg_replace(pattern:'^.+[ \t]*=[ \t]*"(.+)"$', replace:"\1", string:line);
        set_kb_item(name:"Antivirus/BitDefender/Version", value:ver);
      }
    }
    CloseFile(handle:fh);
  }
}

# Pull info about the virus signatures and engine.
sigs = "unknown";
last_update = "unknown";
engine = "unknown";
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path2);
file =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\Plugins\update.txt", string:path2);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc == 1)
{
  fh = CreateFile(
    file:file,
    desired_access:GENERIC_READ,
    file_attributes:FILE_ATTRIBUTE_NORMAL,
    share_mode:FILE_SHARE_READ,
    create_disposition:OPEN_EXISTING
  );
  if (!isnull(fh))
  {
    contents = ReadFile(handle:fh, offset:0, length:256);
    lines = split(contents, keep:FALSE);
    foreach line (lines)
    {
      if ("Signature number:" >< line) 
      {
        sigs = ereg_replace(pattern:"^.*Signature number[ \t]*:[ \t]*([0-9]+)$", replace:"\1", string:line);
        set_kb_item(name:"Antivirus/BitDefender/Sigs", value:sigs);
      }
      else if ("Update time:" >< line) 
      {
        last_update = ereg_replace(pattern:"^.*Update time[ \t]*:[ \t]*(.+)$", replace:"\1", string:line);
      }
      else if ("Version:" >< line) 
      {
        engine = ereg_replace(pattern:"^.*Version[ \t]*:[ \t]*([0-9.]+)$", replace:"\1", string:line);
        set_kb_item(name:"Antivirus/BitDefender/Engine", value:engine);
      }
    }
    CloseFile(handle:fh);
  }
}
NetUseDel();


# Generate report
trouble = 0;

# - general info.
report = "BitDefender is installed on the remote host :

  Product name :      " + name + " 
  Version :           " + ver + "
  Installation path : " + path1 + "
  Signature number :  " + sigs + "
  Signature update :  " + last_update + "
  Engine :            " + engine + "

";

# - sigs out-of-date?
sigs_vendor = "986089";
if (sigs == "unknown" || int(sigs) < int(sigs_vendor))
{
  report += "
The virus signatures on the remote host are out-of-date - the last 
known update from the vendor is signature number " + sigs_vendor + ".

";
  trouble++;
}


# - services running.
services = get_kb_item("SMB/svcs");
if (
  services &&
  (
    ("[ XCOMM ]"  >< services || "BitDefender Communicator" >< services) &&
    ("[ bdss ]"   >< services || "BitDefender Scan Server" >< services) &&
    ("[ VSSERV ]" >< services || "BitDefender Virus Shield" >< services)
  )
) 
{
  # empty
}
else
{
  report += "At least one BitDefender of the services is not running.

";
  trouble++;
}


if (trouble)
{
  report += "As a result, the remote host might be infected by viruses.";

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    report
  );
  security_hole(port:port, data:report);
}
else
{
  # nb: antivirus.nasl uses this in its own report.
  set_kb_item(name:"Antivirus/BitDefender/description", value:report);
}
