#
# (C) Tenable Network Security
#

if(description)
{
  script_id(17193);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2005-0493");
  script_bugtraq_id(12620);
  
  script_name(english:"Bizmail.cgi Mail From Unauthorized Mail Relay Vulnerability");

 desc["english"] = "
Synopsis :

The remote web server contains a CGI script that allows unauthorized
mail relaying. 

Description :

The remote web server is hosting the CGI bizmail.cgi, a CGI script for
sending the content of web forms to email addresses. 

The remote version of this software fails to sanitize the 'email'
parameter to the 'bizmail.cgi' script of CRLF sequences.  An
unauthenticated remote attacker may be able to leverage this issue to
send spam or other sorts of abusive mail through the affected host. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2005-02/0297.html
http://secunia.com/advisories/14351/

Solution: 

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:P/A:N)";
  script_description(english:desc["english"]);
  script_summary(english:"Checks the version of bizmail.cgi");
  script_category(ACT_GATHER_INFO);
  script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
  script_family(english:"CGI abuses");
  script_require_ports("Services/www", 80);
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_dependencie("http_version.nasl");
  exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if ( ! get_port_state(port))exit(0);

foreach dir ( cgi_dirs() )
{
 req = http_get(item: dir + "/bizmail.cgi", port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if ( "Biz Mail Form " >< res )
 {
  if ( egrep(pattern:"Biz Mail Form.* ([01]\.|2\.[02] )", string:res) )
	{
	security_warning( port);
	exit(0);
	}
 }
}
