#
# (C) Tenable Network Security
#

if(description)
{
 script_id(17151);
 script_bugtraq_id(5566, 5567);
 script_cve_id("CVE-2002-1451");
 script_version("$Revision: 1.5 $");
 
 name["english"] = "Blazix Web Server JSP source disclosure";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is affected by an information disclosure
vulnerability. 

Description :

The remote host is running the Blazix web server, a web server written
in Java. 

The installed version of Blazix discloses the source code of its JSP
pages by requesting the pages while appending a plus sign or a
backslash to its name.  An attacker may use this flaw to get the
source code of your CGIs and possibly obtain passwords and other
relevant information about this host. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2002-08/0259.html

Solution : 

Upgrade to Blazix 1.2.2 or newer.

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Attempts to read the source of a jsp page";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "http_version.nasl");
 script_exclude_keys("Settings/disable_cgi_scanning");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");

function check(file)
{
 local_var req, res;

 req = http_get(item:file, port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if( res == NULL ) exit(0);
 if("<%" >< res) return 1;
 return 0;
}

port = get_http_port(default:80);
banner = get_http_banner(port:port);
if ("Server: Blazix Java Server" >!< banner ) exit(0);

if(get_port_state(port))
{
 files = get_kb_list(string("www/", port, "/content/extensions/jsp"));
 if(isnull(files))files = make_list("/index.jsp");
 n = 0;
 foreach file (files)
  {
  if(check(file:file) == 0)
   {
   file = str_replace(string:file, find:".jsp", replace:".jsp+");
   if(check(file:file)) { security_warning(port); exit(0); }
  }
  n++;
  if(n > 10)exit(0);
 }
}
