#
# This script is Copyright (C) Tenable Network Security
#

if(description)
{
 script_id(15703);
 script_version ("$Revision: 1.5 $");

 script_cve_id("CVE-2004-2612");
 script_bugtraq_id(11650);
 script_xref(name:"OSVDB", value:"12144");
 
 name["english"] = "BNC IRC Server Authentication Bypass Vulnerability";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote IRC proxy is susceptible to an authentication bypass issue. 

Description :

The remote host is running a version of the BNC IRC proxy that
contains a flaw in its authentication process that accepted only
logins with incorrect passwords.  An attacker may use this issue to
gain access to the remote IRC proxy server. 

See also :

http://www.gotbnc.com/changes.html#2.9.1

Solution : 

Upgrade to BNC version 2.9.1 or later.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Check BNC authentication bypass";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004-2007 Tenable Network Security");
 family["english"] = "Misc.";
 script_family(english:family["english"]);
 script_require_ports(6667, 6669, 8080);
 exit(0);
}

pwd = string("Nessus", rand());
nick = "nessus";
user = "nessus";


#most common bnc ports 6667,6669,8080

ports = make_list (6667, 6669, 8080);

foreach port (ports)
{
   if(get_port_state(port))
   {

    soc = open_sock_tcp(port);
    if (soc)
    {

     req = 'user nessus nessus nessus nessus\nnick nessus ~\n';
     send(socket: soc, data: req);

     r = recv(socket:soc, length:4096);
     if (r)
     {

       if ("NOTICE AUTH :You need to say /quote PASS <password>" >!< r) exit(0);
       {
         req = string ('pass ', pwd, '\n');
         send (socket:soc, data:req);

         r = recv(socket:soc, length:4096);
         if ((r) && ("NOTICE AUTH :Welcome to BNC" >< r))
         { 
          security_hole(port);
          exit(0);
         }
       }
     }
   close (soc);
  }
 }
}
