#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24223);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-0388");
  script_bugtraq_id(22096);
  script_xref(name:"OSVDB", value:"33872");

  script_name(english:"Burning Board boardids Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL error");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The version of Burning Board / Burning Board Lite on the remote host
fails to sanitize user input to the 'boardids' parameter of the
'search.php' script before using it in database queries.  Regardless
of PHP's 'register_globals' and 'magic_quotes_gpc' settings, an
unauthenticated remote attacker can leverage this issue to launch SQL
injection attacks against the affected application, including
discovery of password hashes of users of the application. 

See also :

http://milw0rm.com/exploits/3143
http://milw0rm.com/exploits/3144
http://milw0rm.com/exploits/3146

Solution :

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("burning_board_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test any installs.
wbb = get_kb_list(string("www/", port, "/burning_board"));
wbblite = get_kb_list(string("www/", port, "/burning_board_lite"));
if (isnull(wbb))
{
  if (isnull(wbblite)) exit(0);
  else installs = make_list(wbblite);
}
else if (isnull(wbblite))
{
  if (isnull(wbb)) exit(0);
  else installs = make_list(wbb);
}
else
{
  kb1 = get_kb_list(string("www/", port, "/burning_board"));
  kb2 = get_kb_list(string("www/", port, "/burning_board_lite"));
  if ( isnull(kb1) ) kb1 = make_list();
  else kb1 = make_list(kb1);
  if ( isnull(kb2) ) kb1 = make_list();
  else kb2 = make_list(kb2);
  installs = make_list(kb1, kb2);
}
foreach install (installs)
{
  matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
  if (!isnull(matches))
  {
    dir = matches[2];

    # First we need some text to search for.
    res = http_get_cache(item:string(dir, "/index.php"), port:port);
    if (res == NULL) exit(0);

    pat = '<a href="thread\\.php\\?goto=lastpost.+ title="([^"]+)">';
    titles = make_list();
    matches = egrep(pattern:pat, string:res);
    if (matches)
    {
      foreach match (split(matches))
      {
        match = chomp(match);
        value = eregmatch(pattern:pat, string:match);
        if (!isnull(value))
        {
          titles = make_list(titles, value[1]);
        }
      }
    }

    # If we have some...
    word = NULL;
    if (max_index(titles))
    {
      # Make sure the affected script exists.
      url = string(dir, "/search.php");
      req = http_get(item:url, port:port);
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      # If it does...
      if ('<select name="boardids[]"' >< res)
      {
        # Try the PoC using words in the titles, if they're long enough.
        # 
        # nb: search term must be between 3 and 19 characters, at least in WBB Lite
        checked = 0;
        foreach title (titles)
        {
          while (!checked && strlen(title))
          {
            matches2 = eregmatch(pattern:"(^| )([a-zA-Z]{3,19})( |$)", string:title);
            if (isnull(matches2)) title = "";
            else
            {
              word = matches2[2];

              # Try to exploit the flaw to generate a SQL error.
              sql = string(rand() % 100, ") ", SCRIPT_NAME);
              postdata = string(
                "searchstring=", word, "&",
                "searchuser=&",
                "name_exactly=1&",
                "boardids[]=", urlencode(str:sql), "&",
                "showposts=0&",
                "searchdate=0&",
                "beforeafter=after&",
                "sortby=lastpost&",
                "sortorder=desc&",
                "send=send&",
                "submit=Suchen"
              );
              req = string(
                "POST ", url, " HTTP/1.1\r\n",
                "Host: ", get_host_name(), "\r\n",
                "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
                "Cookie: wbb_userpassword=0;\r\n",
                "Content-Type: application/x-www-form-urlencoded\r\n",
                "Content-Length: ", strlen(postdata), "\r\n",
                "\r\n",
                postdata
              );
              res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
              if (res == NULL) exit(0);

              # There's a problem if we see an error.
              if (
                "SQL-DATABASE ERROR" &&
                string("boards WHERE boardid IN (0,", sql, ")") >< res
              )
              {
                security_hole(port);
                exit(0);
              }

              title = ereg_replace(pattern:string("^.*", word, "(.*)$"), replace:"\1", string:title);

              # We checked for the flaw as long as we didn't see "Your search 
              # is invalid", which means the word was on a banned list and 
              # the search didn't work.
              if ("Your search is invalid" >!< res) checked = 1;
            }
          }
          if (checked) break;
        }
      }
    }

    if (!checked)
    {
      if (log_verbosity > 1) debug_print("couldn't find a search term to use!", level:0);
    }
  }
}
