#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23734);
  script_version ("$Revision: 1.6 $");

  script_cve_id("CVE-2006-6289");
  script_bugtraq_id(21265);
  script_xref(name:"OSVDB", value:"36906");

  script_name(english:"Burning Board wbb_userid parameter SQL Injection Vulnerability");
  script_summary(english:"Checks for SQL injection vulnerability in Burning Board Lite");
 
  desc = "
Synopsis : 

The remote web server contains a PHP script that is affected by a SQL
injection vulnerability. 

Description :

The remote version of Burning Board Lite fails to sanitize input to
the 'wbb_userid' parameter before using it in a database query. 
Provided PHP's 'register_globals' setting is enabled and
'magic_quotes_gpc' setting is disabled, an unauthenticated attacker
may be able to leverage this issue to uncover sensitive information
(such as password hashes), modify existing data, or launch attacks
against the underlying database. 

See also : 

http://retrogod.altervista.org/wbblite_102_sql.html

Solution : 

Unknown at this time.

Risk factor : 

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("burning_board_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test any installs.
install = get_kb_list(string("www/", port, "/burning_board_lite"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the flaw to cause a SQL error.
  postdata = string(
    "wbb_userid=%27", SCRIPT_NAME, "&",
    "-246470575=1&",
    "-73279541=1"
  );
  req = string(
    "POST ", dir, "/ HTTP/1.1\r\n",
    "Host: ", get_host_name(), "\r\n",
    "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
    "Cookie: wbb_userpassword=0;\r\n",
    "Content-Type: application/x-www-form-urlencoded\r\n",
    "Content-Length: ", strlen(postdata), "\r\n",
    "\r\n",
    postdata
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see a database error with our script name.
  if (
    "SQL-DATABASE ERROR" >< res &&
    string("WHERE userid = ''", SCRIPT_NAME) >< res
  ) security_warning(port);
}
