#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23963);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2006-6799");
  script_bugtraq_id(21799);
  script_xref(name:"OSVDB", value:"31468");

  script_name(english:"Cacti cmd.php Arbitrary Command Execution Vulnerability");
  script_summary(english:"Checks if Cacti's cmd.php is remotely accessible");

  desc = "
Synopsis :

The remote web server contains a PHP script that allows arbitrary
command execution. 

Description :

The remote host is running Cacti, a web-based frontend to RRDTool for
network graphing. 

The version of Cacti on the remote host does not properly check
whether ensure the 'cmd.php' script is being run from a commandline
and fails to sanitize user-supplied input before using it in database
queries.  Provided PHP's 'register_argc_argv' parameter is enabled,
which is the default, an attacker can launch SQL injection attacks
against the underlying database and even to execute arbitrary code on
the remote host subject to the privileges of the web server user id. 

See also :

http://milw0rm.com/exploits/3029
http://forums.cacti.net/about18846.html
http://bugs.cacti.net/view.php?id=883
http://www.cacti.net/release_notes_0_8_6j.php

Solution :

Upgrade to Cacti version 0.8.6j or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through CGI directories.
foreach dir (cgi_dirs())
{
  # Check whether we can pass arguments to the script.
  req = http_get(item:string(dir, "/cmd.php?1+1+0"), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we can.
  if ("Invalid Arguments.  The first argument must be less" >< res)
  {
    security_hole(port);
    exit(0);
  }
}
