#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23964);
  script_version("$Revision: 1.3 $");

  script_bugtraq_id(21823);

  script_name(english:"Cacti copy_cacti_user SQL Injection Vulnerability");
  script_summary(english:"Checks if Cacti's copy_cacti_user.php is remotely accessible");

  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by a SQL
injection issue. 

Description :

The remote host is running Cacti, a web-based frontend to RRDTool for
network graphing. 

The version of Cacti on the remote host does not properly check
whether the 'copy_cacti_user.php' script is being run from a
commandline and fails to sanitize user-supplied input before using it
in database queries.  Provided PHP's 'register_argc_argv' parameter is
enabled, which is the default, an attacker can leverage this issue to
launch SQL injection attack against the underlying database and, for
example, add arbitrary administrative users. 

See also :

http://milw0rm.com/exploits/3045

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through CGI directories.
foreach dir (cgi_dirs())
{
  # Check whether we can pass arguments to the script.
  req = http_get(item:string(dir, "/copy_cacti_user.php?", SCRIPT_NAME), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we can.
  if ("php copy_cacti_user.php <template user>" >< res)
  {
    security_hole(port);
    exit(0);
  }
}
