#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2007-0356.

See also :

https://rhn.redhat.com/errata/RHSA-2007-0356.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(25256);
 script_version("$Revision: 1.2 $");
 script_name(english:"CentOS : RHSA-2007-0356");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2007 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"libpng10-1.0.13-17", release:"CentOS-3", cpu:"i386") )  faulty += '- libpng10-1.0.13-17\n';
if ( rpm_check(reference:"libpng10-devel-1.0.13-17", release:"CentOS-3", cpu:"i386") )  faulty += '- libpng10-devel-1.0.13-17\n';
if ( rpm_check(reference:"libpng-1.2.2-27", release:"CentOS-3", cpu:"i386") )  faulty += '- libpng-1.2.2-27\n';
if ( rpm_check(reference:"libpng-devel-1.2.2-27", release:"CentOS-3", cpu:"i386") )  faulty += '- libpng-devel-1.2.2-27\n';
if ( rpm_check(reference:"libpng10-1.0.13-17", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libpng10-1.0.13-17\n';
if ( rpm_check(reference:"libpng10-devel-1.0.13-17", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libpng10-devel-1.0.13-17\n';
if ( rpm_check(reference:"libpng-1.2.2-27", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libpng-1.2.2-27\n';
if ( rpm_check(reference:"libpng-devel-1.2.2-27", release:"CentOS-3", cpu:"x86_64") )  faulty += '- libpng-devel-1.2.2-27\n';
if ( rpm_check(reference:"libpng10-1.0.16-3", release:"CentOS-4", cpu:"i386") )  faulty += '- libpng10-1.0.16-3\n';
if ( rpm_check(reference:"libpng10-1.0.16-3", release:"CentOS-4", cpu:"x86_64") )  faulty += '- libpng10-1.0.16-3\n';
if ( rpm_check(reference:"libpng10-devel-1.0.16-3", release:"CentOS-4", cpu:"x86_64") )  faulty += '- libpng10-devel-1.0.16-3\n';
if ( rpm_check(reference:"libpng-1.2.7-3.el4", release:"CentOS-4", cpu:"i386") )  faulty += '- libpng-1.2.7-3.el4\n';
if ( rpm_check(reference:"libpng-1.2.7-3.el4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- libpng-1.2.7-3.el4\n';
if ( rpm_check(reference:"libpng-devel-1.2.7-3.el4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- libpng-devel-1.2.7-3.el4\n';
if ( rpm_check(reference:"libpng10-devel-1.0.16-3", release:"CentOS-4", cpu:"i386") )  faulty += '- libpng10-devel-1.0.16-3\n';
if ( rpm_check(reference:"libpng-devel-1.2.7-3.el4", release:"CentOS-4", cpu:"i386") )  faulty += '- libpng-devel-1.2.7-3.el4\n';
if ( rpm_check(reference:"libpng-1.2.2-27", release:"CentOS-3", cpu:"ia64") )  faulty += '- libpng-1.2.2-27\n';
if ( rpm_check(reference:"libpng-devel-1.2.2-27", release:"CentOS-3", cpu:"ia64") )  faulty += '- libpng-devel-1.2.2-27\n';
if ( rpm_check(reference:"libpng10-1.0.13-17", release:"CentOS-3", cpu:"ia64") )  faulty += '- libpng10-1.0.13-17\n';
if ( rpm_check(reference:"libpng10-devel-1.0.13-17", release:"CentOS-3", cpu:"ia64") )  faulty += '- libpng10-devel-1.0.13-17\n';
if ( rpm_check(reference:"libpng-1.2.7-3.el4", release:"CentOS-4", cpu:"ia64") )  faulty += '- libpng-1.2.7-3.el4\n';
if ( rpm_check(reference:"libpng-devel-1.2.7-3.el4", release:"CentOS-4", cpu:"ia64") )  faulty += '- libpng-devel-1.2.7-3.el4\n';
if ( rpm_check(reference:"libpng10-1.0.16-3", release:"CentOS-4", cpu:"ia64") )  faulty += '- libpng10-1.0.16-3\n';
if ( rpm_check(reference:"libpng10-devel-1.0.16-3", release:"CentOS-4", cpu:"ia64") )  faulty += '- libpng10-devel-1.0.16-3\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
