#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2007-0740.

See also :

https://rhn.redhat.com/errata/RHSA-2007-0740.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(25778);
 script_version("$Revision: 1.2 $");
 script_name(english:"CentOS : RHSA-2007-0740");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2007 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"bind-9.2.4-21.el3", release:"CentOS-3", cpu:"i386") )  faulty += '- bind-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-chroot-9.2.4-21.el3", release:"CentOS-3", cpu:"i386") )  faulty += '- bind-chroot-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-devel-9.2.4-21.el3", release:"CentOS-3", cpu:"i386") )  faulty += '- bind-devel-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-libs-9.2.4-21.el3", release:"CentOS-3", cpu:"i386") )  faulty += '- bind-libs-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-utils-9.2.4-21.el3", release:"CentOS-3", cpu:"i386") )  faulty += '- bind-utils-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-9.2.4-21.el3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- bind-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-chroot-9.2.4-21.el3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- bind-chroot-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-devel-9.2.4-21.el3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- bind-devel-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-libs-9.2.4-21.el3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- bind-libs-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-utils-9.2.4-21.el3", release:"CentOS-3", cpu:"x86_64") )  faulty += '- bind-utils-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-9.2.4-21.el3", release:"CentOS-3", cpu:"ia64") )  faulty += '- bind-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-chroot-9.2.4-21.el3", release:"CentOS-3", cpu:"ia64") )  faulty += '- bind-chroot-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-devel-9.2.4-21.el3", release:"CentOS-3", cpu:"ia64") )  faulty += '- bind-devel-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-libs-9.2.4-21.el3", release:"CentOS-3", cpu:"ia64") )  faulty += '- bind-libs-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-utils-9.2.4-21.el3", release:"CentOS-3", cpu:"ia64") )  faulty += '- bind-utils-9.2.4-21.el3\n';
if ( rpm_check(reference:"bind-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"ia64") )  faulty += '- bind-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-chroot-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"ia64") )  faulty += '- bind-chroot-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-devel-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"ia64") )  faulty += '- bind-devel-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-libs-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"ia64") )  faulty += '- bind-libs-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-utils-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"ia64") )  faulty += '- bind-utils-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- bind-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-chroot-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- bind-chroot-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-devel-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- bind-devel-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-devel-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- bind-devel-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-libbind-devel-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- bind-libbind-devel-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-libbind-devel-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- bind-libbind-devel-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-libs-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- bind-libs-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-libs-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- bind-libs-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-sdb-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- bind-sdb-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-utils-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- bind-utils-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"caching-nameserver-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"x86_64") )  faulty += '- caching-nameserver-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- bind-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-chroot-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- bind-chroot-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-sdb-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- bind-sdb-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-utils-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- bind-utils-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"caching-nameserver-9.3.3-9.0.1.el5", release:"CentOS-5", cpu:"i386") )  faulty += '- caching-nameserver-9.3.3-9.0.1.el5\n';
if ( rpm_check(reference:"bind-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- bind-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-chroot-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- bind-chroot-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-devel-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- bind-devel-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-libs-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"i386") )  faulty += '- bind-libs-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-libs-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- bind-libs-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-utils-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- bind-utils-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"i386") )  faulty += '- bind-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-chroot-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"i386") )  faulty += '- bind-chroot-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-devel-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"i386") )  faulty += '- bind-devel-9.2.4-27.0.1.el4\n';
if ( rpm_check(reference:"bind-utils-9.2.4-27.0.1.el4", release:"CentOS-4", cpu:"i386") )  faulty += '- bind-utils-9.2.4-27.0.1.el4\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
