#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2008-0038.

See also :

https://rhn.redhat.com/errata/RHSA-2008-0038.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(29933);
 script_version("$Revision: 1.2 $");
 script_name(english:"CentOS : RHSA-2008-0038");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2008 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"postgresql-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-contrib-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-contrib-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-devel-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-devel-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-docs-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-docs-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-jdbc-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-jdbc-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-libs-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-libs-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-pl-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-pl-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-python-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-python-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-server-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-server-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-tcl-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-tcl-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-test-7.4.19-1.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- postgresql-test-7.4.19-1.c4.1\n';
if ( rpm_check(reference:"postgresql-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-contrib-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-contrib-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-devel-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-devel-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-docs-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-docs-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-jdbc-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-jdbc-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-libs-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-libs-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-libs-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-libs-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-pl-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-pl-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-python-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-python-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-server-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-server-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-tcl-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-tcl-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-test-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- postgresql-test-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-contrib-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-contrib-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-devel-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-devel-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-docs-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-docs-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-jdbc-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-jdbc-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-pl-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-pl-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-python-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-python-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-server-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-server-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-tcl-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-tcl-7.4.19-1.el4_6.1\n';
if ( rpm_check(reference:"postgresql-test-7.4.19-1.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- postgresql-test-7.4.19-1.el4_6.1\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
