#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2008-0110.

See also :

https://rhn.redhat.com/errata/RHSA-2008-0110.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(31138);
 script_version("$Revision: 1.1 $");
 script_name(english:"CentOS : RHSA-2008-0110");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2008 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"compat-openldap-2.1.30-8.el4_6.4", release:"CentOS-4", cpu:"i386") )  faulty += '- compat-openldap-2.1.30-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"i386") )  faulty += '- openldap-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-clients-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"i386") )  faulty += '- openldap-clients-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-devel-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"i386") )  faulty += '- openldap-devel-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-servers-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"i386") )  faulty += '- openldap-servers-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-servers-sql-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"i386") )  faulty += '- openldap-servers-sql-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"compat-openldap-2.1.30-8.el4_6.4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- compat-openldap-2.1.30-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- openldap-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-clients-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- openldap-clients-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-devel-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- openldap-devel-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-servers-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- openldap-servers-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"openldap-servers-sql-2.2.13-8.el4_6.4", release:"CentOS-4", cpu:"x86_64") )  faulty += '- openldap-servers-sql-2.2.13-8.el4_6.4\n';
if ( rpm_check(reference:"compat-openldap-2.1.30-8.c4.4", release:"CentOS-4", cpu:"ia64") )  faulty += '- compat-openldap-2.1.30-8.c4.4\n';
if ( rpm_check(reference:"openldap-2.2.13-8.c4.4", release:"CentOS-4", cpu:"ia64") )  faulty += '- openldap-2.2.13-8.c4.4\n';
if ( rpm_check(reference:"openldap-clients-2.2.13-8.c4.4", release:"CentOS-4", cpu:"ia64") )  faulty += '- openldap-clients-2.2.13-8.c4.4\n';
if ( rpm_check(reference:"openldap-devel-2.2.13-8.c4.4", release:"CentOS-4", cpu:"ia64") )  faulty += '- openldap-devel-2.2.13-8.c4.4\n';
if ( rpm_check(reference:"openldap-servers-2.2.13-8.c4.4", release:"CentOS-4", cpu:"ia64") )  faulty += '- openldap-servers-2.2.13-8.c4.4\n';
if ( rpm_check(reference:"openldap-servers-sql-2.2.13-8.c4.4", release:"CentOS-4", cpu:"ia64") )  faulty += '- openldap-servers-sql-2.2.13-8.c4.4\n';
if ( rpm_check(reference:"compat-openldap-2.3.27_2.2.29-8.el5_1.3", release:"CentOS-5", cpu:"i386") )  faulty += '- compat-openldap-2.3.27_2.2.29-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"i386") )  faulty += '- openldap-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-clients-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"i386") )  faulty += '- openldap-clients-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-devel-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"i386") )  faulty += '- openldap-devel-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-servers-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"i386") )  faulty += '- openldap-servers-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-servers-sql-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"i386") )  faulty += '- openldap-servers-sql-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"compat-openldap-2.3.27_2.2.29-8.el5_1.3", release:"CentOS-5", cpu:"x86_64") )  faulty += '- compat-openldap-2.3.27_2.2.29-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"x86_64") )  faulty += '- openldap-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-clients-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"x86_64") )  faulty += '- openldap-clients-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-devel-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"x86_64") )  faulty += '- openldap-devel-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-servers-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"x86_64") )  faulty += '- openldap-servers-2.3.27-8.el5_1.3\n';
if ( rpm_check(reference:"openldap-servers-sql-2.3.27-8.el5_1.3", release:"CentOS-5", cpu:"x86_64") )  faulty += '- openldap-servers-sql-2.3.27-8.el5_1.3\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
