#
# (C) Tenable Network Security, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);
desc = "
Synopsis :

The remote host is missing a security update.

Description :

The remote CentOS system is missing a security update which has been 
documented in Red Hat advisory RHSA-2008-0146.

See also :

https://rhn.redhat.com/errata/RHSA-2008-0146.html

Solution :

Upgrade to the newest packages by doing :

  yum update

Risk factor :

High";

if ( description )
{
 script_id(31310);
 script_version("$Revision: 1.1 $");
 script_name(english:"CentOS : RHSA-2008-0146");
 script_description(english:desc);

 script_summary(english:"Checks for missing updates on the remote CentOS system");
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is (C) 2008 Tenable Network Security, Inc.");
 script_family(english:"CentOS Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/CentOS/rpm-list");
 exit(0);
}

include("rpm.inc");

if ( rpm_check(reference:"gd-2.0.28-5.4E.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- gd-2.0.28-5.4E.c4.1\n';
if ( rpm_check(reference:"gd-devel-2.0.28-5.4E.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- gd-devel-2.0.28-5.4E.c4.1\n';
if ( rpm_check(reference:"gd-progs-2.0.28-5.4E.c4.1", release:"CentOS-4", cpu:"ia64") )  faulty += '- gd-progs-2.0.28-5.4E.c4.1\n';
if ( rpm_check(reference:"gd-2.0.28-5.4E.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- gd-2.0.28-5.4E.el4_6.1\n';
if ( rpm_check(reference:"gd-devel-2.0.28-5.4E.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- gd-devel-2.0.28-5.4E.el4_6.1\n';
if ( rpm_check(reference:"gd-progs-2.0.28-5.4E.el4_6.1", release:"CentOS-4", cpu:"i386") )  faulty += '- gd-progs-2.0.28-5.4E.el4_6.1\n';
if ( rpm_check(reference:"gd-2.0.28-5.4E.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- gd-2.0.28-5.4E.el4_6.1\n';
if ( rpm_check(reference:"gd-devel-2.0.28-5.4E.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- gd-devel-2.0.28-5.4E.el4_6.1\n';
if ( rpm_check(reference:"gd-progs-2.0.28-5.4E.el4_6.1", release:"CentOS-4", cpu:"x86_64") )  faulty += '- gd-progs-2.0.28-5.4E.el4_6.1\n';
if ( faulty ) security_hole(port:0, data:desc + '\n\nPlugin output :\n\nThe following RPMs need to be updated :\n' + faulty);
