#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25906);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-4414", "CVE-2007-4415");
  script_bugtraq_id(25332);

  script_name(english:"Cisco VPN Client Dial-up Networking Interface Privilege Escalation Vulnerability");
  script_summary(english:"Checks version of vpngui.exe");

  desc = "
Synopsis :

The remote Windows host has a program that is prone to a local
privilege escalation attack. 

Description :

The version of the Cisco VPN client installed on the remote host
reportedly allows an unprivileged local user to elevate his privileges
to the LocalSystem account by enabling the 'Start Before Login'
feature and configuring a VPN profile to use Microsoft's Dial-Up
Networking interface. 

See also :

http://www.cisco.com/warp/public/707/cisco-sa-20070815-vpnclient.shtml
http://www.securityfocus.com/archive/1/476651/30/0/threaded

Solution :

Upgrade to Cisco VPN Client version 4.8.02.0010 or later. 

Risk factor :

Medium / CVSS Base Score : 6.8
(CVSS2#AV:L/AC:L/Au:S/C:C/I:C/A:C)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("cisco_vpn_client_detect.nasl");
  script_require_keys("SMB/CiscoVPNClient/Version");

  exit(0);
}


ver = get_kb_item("SMB/CiscoVPNClient/Version");
if (isnull(ver)) exit(0);

iver = split(ver, sep:'.', keep:FALSE);
for (i=0; i<4; i++)
  iver[i] = int(iver[i]);

fix = split("4.8.02.0010", sep:'.', keep:FALSE);
for (i=0; i<4; i++)
  fix[i] = int(fix[i]);

for (i=0; i<max_index(iver); i++)
  if ((iver[i] < fix[i]))
  {
    security_warning(get_kb_item("SMB/transport"));
    break;
  }
  else if (iver[i] > fix[i])
    break;
