#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30123);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2008-0394");
  script_bugtraq_id(27376);

  script_name(english:"Citadel SMTP Server RCPT TO Buffer Overflow Vulnerability");
  script_summary(english:"Checks Citadel's version number");

  desc = "
Synopsis :

The remote mail server is prone to a buffer overflow attack. 

Description :

The remote server is running Citadel, an open-source solution for
email and collaboration. 

According to its version, the installation of Citadel on the remote
host uses insufficient bounds-checking in its SMTP service during
memory-copy operations when processing input to the RCPT TO command. 
An unauthenticated remote attacker may be able to leverage this issue
to cause a stack-based buffer overflow, resulting in a crash of the
affected service or even execution of arbitrary code. 

See also :

http://www.milw0rm.com/exploits/4949
http://article.gmane.org/gmane.comp.cms.citadel.devel/2518
http://article.gmane.org/gmane.comp.cms.citadel.devel/2569
http://article.gmane.org/gmane.comp.cms.citadel.user/3463

Solution :

Upgrade to Citadel version 7.11 or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"SMTP problems");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("find_service2.nasl", "citadel_overflow.nasl");
  script_require_ports("Services/smtp", 25, "Services/citadel/ux", 504);

  exit(0);
}


include("global_settings.inc");
include("smtp_func.inc");


# nb: banner checks of open-source software are prone to false-
#     positives so only run the check if reporting is paranoid.
if (report_paranoia < 2) exit(0);


citadel_port = get_kb_item("Services/citadel/ux");
if (!citadel_port) exit(0);

kb = get_kb_item("citadel/" + citadel_port + "/version");
if (!kb) exit(0);


port = get_kb_item("Services/smtp");
if (!port) port = 25;

banner = get_smtp_banner(port:port);
if (banner && "ESMTP Citadel server ready." >< banner)
{
  ver = ereg_replace(pattern:"^Citadel(/UX)? +([0-9]+.+)$", replace:"\2", string:kb);
  if (ver && ver =~ "^[0-6]\.|7\.0|10($|[^0-9])")
  {
    if (report_verbosity)
    {
      report = string(
        "\n",
        "The remote Citadel server reports itself as :\n",
        "\n",
        "  ", kb, "\n"
      );
      security_hole(port:port, extra:report);
    }
    else security_hole(port);
  }
}
