#
# This script was written by Tenable Network Security
#

if(description)
{
 script_id(16275);
 script_bugtraq_id(12392); 
 script_version ("$Revision: 1.5 $");

 name["english"] = "CoolForum SQL Injection flaws";

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host contains a PHP script that is affected by multiple SQL
injection issues. 

Description :

The version of CoolForum, a bulletin-board application written in PHP,
installed on the remote host fails to sanitize input to several
parameters to scripts in the 'admin' directory before using it in
database queries.  An attacker could leverage these issues to
manipulate SQL queries or attack the underlying database. 

Solution: 

Upgrade to CoolForum 0.7.3 or higher.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the presence of CoolForum";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

function check(loc)
{
 local_var r, req;
 global_var port;

 req = http_get(item:string(loc, "/index.php"), port:port);
 r = http_keepalive_send_recv(port:port, data:req, bodyonly: 1);
 if( r == NULL )exit(0);

 if ( egrep(pattern:"Powered by <b>CoolForum v\.0\.([0-6]\..*|7\.[0-2])", string:r) ) 
 {
   security_hole(port);
   exit(0);
 }
}

foreach dir (cgi_dirs())
{
 check(loc:dir);
}
