#
# (C) Tenable Network Security
#

if(description)
{
 script_id(17306);
 script_version("$Revision: 1.5 $");

 script_cve_id("CVE-2005-0697");
 script_bugtraq_id(12740);

 name["english"] = "CopperExport XP_Publish.PHP SQL Injection Vulnerability";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server contains a PHP script that is affected by a SQL
injection flaw. 

Description :

The remote host is running CopperExport, a plugin for iPhoto that
allows an iPhoto user to export images to a Coppermine gallery. 

The remote version of this software fails to sanitize unspecified
input to the 'xp_publish.php' script before using it in a SQL query. 

Note that successful exploitation requires that an attacker be
authenticated. 

See also :

http://archives.neohapsis.com/archives/secunia/2005-q1/0814.html

Solution : 

Upgrade to CopperExport 0.2.1 or later.

Risk factor :

Medium / CVSS Base Score : 6.5
(CVSS2#AV:N/AC:L/Au:S/C:P/I:P/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "SQL Injection in CopperExport";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencies("http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");


function check(dir)
{
  local_var buf, req;
  global_var port;

  req = http_get(item:dir + "/ChangeLog", port:port);
  buf = http_keepalive_send_recv(port:port, data:req);
  if(buf == NULL)exit(0);

  if("initial release of CopperExport." ><  buf &&
     "Version 0.2.1" >!< buf )
  	{
	security_warning(port);
	exit(0);
	}
 
 
 return(0);
}

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if ( ! can_host_php(port:port) ) exit(0);


foreach dir (cgi_dirs()) check( dir : dir );
