#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

A data migration service is listening on the remote host. 

Description :

The remote service is a BrightStor HSM Engine, the engine component of
BrightStor Hierarchical Storage Manager, which is used to manage files
on the remote host as part of an enterprise-grade tiered storage
solution. 

See also :

http://www.ca.com/us/products/collateral.aspx?cid=74992&id=370

Solution :

Limit incoming traffic to this port if desired. 

Risk factor :

None";


if (description)
{
  script_id(26912);
  script_version("$Revision: 1.2 $");

  script_name(english:"BrightStor HSM Engine Detection (TCP)");
  script_summary(english:"Scans for HSM Engine via TCP");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/unknown", 2000);

  exit(0);
}


include("byte_func.inc");
include("global_settings.inc");
include("misc_func.inc");

 
if (thorough_tests && ! get_kb_item("global_settings/disable_service_discovery")  )
{
  port = get_unknown_svc(2000);
  if (!port) exit(0);
}
else port = 2000;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Send an initial message.
set_byte_order(BYTE_ORDER_LITTLE_ENDIAN);

req = mkdword(0x42) +
  mkdword(0x07) +
  mkdword(0x00) +
  mkdword(0x00);
req = 
  mkdword(strlen(req)+4) +
  req;
send(socket:soc, data:req);


# Read the reply.
res = recv(socket:soc, length:4);
if (strlen(res) != 4) exit(0);

len = getdword(blob:res, pos:0);
# nb: the 100 character limit is arbitrary but will avoid wasting time if
#     the remote is a more verbose service.
if (len < 100)
{
  len -= 4;
  res = recv(socket:soc, length:len);

  # If...
  if (
    # it's the expected length and...
    strlen(res) == len &&
    # the initial dword is 0x42 and...
    0x42 == getdword(blob:res, pos:0) &&
    # the second dword is 0x07 and...
    0x07 == getdword(blob:res, pos:4)
  )
  {
    # Register and report the service.
    register_service(port:port, proto:"hsm_csagent");
    security_note(port);
  }
}
