#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29802);
  script_version("$Revision: 1.2 $");

  script_bugtraq_id(27010);
  script_xref(name:"OSVDB", value:"39888");

  script_name(english:"CuteNews files_arch Information Disclosure Vulnerability");
  script_summary(english:"Adds a non-existent file to files_arch");

  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
an information disclosure issue. 

Description :

The version of CuteNews on the remote host fails to initialize the
'files_arch[]' array before populating it with a list of files to
search in the 'search.php' script.  Regardless of PHP's
'register_globals' setting, an unauthenticated attacker can leverage
this issue to determine the existence of arbitrary files on the
affected host or search files for arbitrary text, such as usernames
and password hashes defined to the affected application. 

See also :

http://www.securityfocus.com/archive/1/485485/30/0/threaded
http://www.milw0rm.com/exploits/4779

Solution :

Unknown at this time. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("cutenews_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/cutenews"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];

  # Try to exploit the flaw to simply generate an error message.
  arch = SCRIPT_NAME;

  req = http_get(
    item:string(
      dir, "/search.php?",
      "dosearch=yes&",
      "files_arch[]=", arch
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if 
  if (
    string("file(", arch, "): failed to open stream") >< res ||
    string("file(", arch, ") [function.file]: failed to open stream") >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
