#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24003);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-0147");
  script_bugtraq_id(21927);
  script_xref(name:"OSVDB", value:"32643");

  script_name(english:"Cuyahoga FCKEditor Security Bypass Vulnerability");
  script_summary(english:"Tries to call FCKEditor's upload.php script");

  desc = "
Synopsis :

The remote web server contains a .NET application that is affected by a
security bypass vulnerability. 

Description :

The remote host is running Cuyahoga, an open-source .NET web site
framework. 

The installation of Cuyahoga fails to require authorization to access
the FCKEditor component included with it.  An unauthenticated remote
attacker may be able to leverage this flaw to view and upload files
with FCKEditor. 

See also :

http://www.cuyahoga-project.org/10/section.aspx/61

Solution :

Either retrieve the updated 'Web.config' file and place it in the
'Support/FCKeditor/editor/filemanager' directory of the affected site
or upgrade to Cuyahoga 1.0.1 or later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Loop through directories.
foreach dir (make_list(cgi_dirs()))
{
  # Check if one of the script exists.
  url = string(dir, "/Support/FCKEditor/editor/filemanager/upload/asp/upload.asp");
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if it does and is not disabled.
  if ("OnUploadCompleted" >< res && "file uploader is disabled" >!< res)
  {
    security_warning(port);
    exit(0);
  }
}
