#
# (C) Tenable Network Security
#

if(description)
{
 script_id(17208);
 script_version ("$Revision: 1.5 $");
  
 script_cve_id("CVE-2005-0546");
 script_bugtraq_id(12636);

 name["english"] = "Cyrus IMAP Multiple Vulnerabilities";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote IMAP server is affected by multiple buffer overflow issues. 

Description :

According to its banner, the remote Cyrus IMAP server is affected by
off-by-one errors in its imapd annotate extension and its cached
header handling which can be triggered by an authenticated user, a
buffer overflow in fetchnews that can be triggered by a peer news
admin, and an unspecified stack-based buffer overflow in imapd. 

See also :

http://cyrusimap.web.cmu.edu//imapd/changes.html

Solution :

Upgrade to Cyrus IMAP server version 2.2.11 or later. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the banner of Cyrus IMAPd";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 script_copyright(english:"This script is Copyright (C) 2005-2008 Tenable Network Security");
 script_family(english:"Gain a shell remotely");

 script_dependencie("cyrus_imap_prelogin_overflow.nasl");
 script_require_ports("Services/imap", 143);

 exit(0);
}

#
# The script code starts here
#

include("imap_func.inc");
port = get_kb_item("Services/imap");
if(!port) port = 143;

banner = get_kb_item("imap/" + port + "/Cyrus");
if ( ! banner ) exit(0);
if(egrep(pattern:"^(1\..*|2\.0\..*|2\.1\.[1-9][^0-9]|2\.1\.1[01])[0-9]*$", string:banner))
    security_hole(port);
