#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23936);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2006-4257");
  script_bugtraq_id(19586);
  script_xref(name:"OSVDB", value:"27993");

  script_name(english:"DB2 < 8.1 FixPak 13");
  script_summary(english:"Checks DB2 signature");

  desc = "
Synopsis :

The remote database server is affected by multiple denial of service
issues. 

Description :

According to its version, the installation of DB2 on the remote host
may crash in certain scenarios, such as when a user connects using a
specially-crafted ACCSEC command during the handshake process. 

See also : 

http://www.securityfocus.com/archive/1/archive/1/445298/100/0/threaded
http://www.securityfocus.com/archive/1/454307/30/0/threaded
http://www-1.ibm.com/support/docview.wss?uid=swg24013114

Solution : 

Apply DB2 UDB Version 8.1 FixPak 13 or later. 

Risk factor : 

Medium / CVSS Base Score : 4.0
(CVSS2#AV:N/AC:L/Au:S/C:N/I:N/A:P)";
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Databases");
 
  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");
 
  script_dependencies("db2_das_detect.nasl");
  script_require_ports("Services/db2das", 523);

  exit(0);
}


port = get_kb_item("Services/db2das");
if (!port) port = 523;
if (!get_port_state(port)) exit(0);


# Make sure the port is really open.
soc = open_sock_tcp(port);
if (!soc) exit(0);
close(soc);


function is_level_older(lvl, base, min)
{
  if (isnull(lvl) || isnull(base)) return NULL;

  local_var i, v1, v2, vmin;

  v1 = split(lvl, sep:'.', keep:0);
  v2 = split(base, sep:'.', keep:0);
  if (isnull(min)) vmin = make_list(0,0,0,0);
  else vmin = split(min, sep:'.', keep:0);

  v1 = make_list(int(v1[0]), int(v1[1]), int(v1[2]), int(v1[3]));
  v2 = make_list(int(v2[0]), int(v2[1]), int(v2[2]), int(v2[3]));
  vmin = make_list(int(vmin[0]), int(vmin[1]), int(vmin[2]), int(vmin[3]));

  for (i=0; i<max_index(v1); i++)
    if (v1[i] < v2[i])
    {
      if (v1[i] < vmin[i]) return FALSE;
      else return TRUE;
    }
    else if (v1[i] > v2[i]) return FALSE;

  return FALSE;
}


platform = get_kb_item("DB2/" + port + "/Platform");
level = get_kb_item("DB2/" + port + "/Level");
if (platform && level)
{
  if (
    # Windows, x86
    (platform == 5 && is_level_older(lvl:level, base:"8.1.13.193")) ||
    # Linux, x86, 2.6 kernel
    (platform == 18 && is_level_older(lvl:level, base:"8.1.2.120"))
  ) security_warning(port);
}
