# This script was automatically generated from the dsa-1102
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Steve Kemp from the Debian Security Audit project discovered that
pinball, a pinball simulator, can be tricked into loading level
plugins from user-controlled directories without dropping privileges.
The old stable distribution (woody) does not contain this package.
For the stable distribution (sarge) this problem has been fixed in
version 0.3.1-3sarge1.
For the unstable distribution (sid) this problem has been fixed in
version 0.3.1-6.
We recommend that you upgrade your pinball package.


Solution : http://www.debian.org/security/2006/dsa-1102
Risk factor : High';

if (description) {
 script_id(22644);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1102");
 script_cve_id("CVE-2006-2196");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1102] DSA-1102-1 pinball");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1102-1 pinball");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'pinball', release: '3.1', reference: '0.3.1-3sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pinball is vulnerable in Debian 3.1.\nUpgrade to pinball_0.3.1-3sarge1\n');
}
if (deb_check(prefix: 'pinball-data', release: '3.1', reference: '0.3.1-3sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pinball-data is vulnerable in Debian 3.1.\nUpgrade to pinball-data_0.3.1-3sarge1\n');
}
if (deb_check(prefix: 'pinball-dev', release: '3.1', reference: '0.3.1-3sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pinball-dev is vulnerable in Debian 3.1.\nUpgrade to pinball-dev_0.3.1-3sarge1\n');
}
if (deb_check(prefix: 'pinball', release: '3.1', reference: '0.3.1-3sarge1')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package pinball is vulnerable in Debian sarge.\nUpgrade to pinball_0.3.1-3sarge1\n');
}
if (w) { security_hole(port: 0, data: desc); }
