# This script was automatically generated from the dsa-1205
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
The original advisory for this issue didn\'t contain fixed packages for all
supported architectures which are corrected in this update. For reference
please find below the original advisory text:
Marco d\'Itri discovered that thttpd, a small, fast and secure webserver,
makes use of insecure temporary files when its logfiles are rotated,
which might lead to a denial of service through a symlink attack.
For the stable distribution (sarge) this problem has been fixed in
version 2.23beta1-3sarge2.
For the unstable distribution (sid) this problem has been fixed in
version 2.23beta1-5.
We recommend that you upgrade your thttpd package.


Solution : http://www.debian.org/security/2006/dsa-1205
Risk factor : High';

if (description) {
 script_id(22937);
 script_version("$Revision: 1.5 $");
 script_xref(name: "DSA", value: "1205");
 script_cve_id("CVE-2006-4248");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1205] DSA-1205-2 thttpd");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1205-2 thttpd");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'thttpd', release: '3.1', reference: '2.23beta1-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thttpd is vulnerable in Debian 3.1.\nUpgrade to thttpd_2.23beta1-3sarge2\n');
}
if (deb_check(prefix: 'thttpd-util', release: '3.1', reference: '2.23beta1-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thttpd-util is vulnerable in Debian 3.1.\nUpgrade to thttpd-util_2.23beta1-3sarge2\n');
}
if (deb_check(prefix: 'thttpd', release: '3.1', reference: '2.23beta1-3sarge2')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package thttpd is vulnerable in Debian sarge.\nUpgrade to thttpd_2.23beta1-3sarge2\n');
}
if (w) { security_hole(port: 0, data: desc); }
