# This script was automatically generated from the dsa-1206
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
Several remote vulnerabilities have been discovered in PHP, a
server-side, HTML-embedded scripting language, which may lead to the
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:
    Tim Starling discovered that missing input sanitising in the EXIF
    module could lead to denial of service.
    Stefan Esser discovered a security-critical programming error in the
    hashtable implementation of the internal Zend engine.
    It was discovered that str_repeat() and wordwrap() functions perform
    insufficient checks for buffer boundaries on 64 bit systems, which
    might lead to the execution of arbitrary code.
    Stefan Esser discovered a buffer overflow in the htmlspecialchars()
    and htmlentities(), which might lead to the execution of arbitrary
    code.
For the stable distribution (sarge) these problems have been fixed in
version 4:4.3.10-18. Builds for hppa and m68k will be provided later
once they are available.
For the unstable distribution (sid) these problems have been fixed in
version 4:4.4.4-4 of php4 and version 5.1.6-6 of php5.
We recommend that you upgrade your php4 packages.


Solution : http://www.debian.org/security/2006/dsa-1206
Risk factor : High';

if (description) {
 script_id(23655);
 script_version("$Revision: 1.3 $");
 script_xref(name: "DSA", value: "1206");
 script_cve_id("CVE-2005-3353", "CVE-2006-3017", "CVE-2006-4482", "CVE-2006-5465");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1206] DSA-1206-1 php4");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1206-1 php4");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'libapache-mod-php4', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache-mod-php4 is vulnerable in Debian 3.1.\nUpgrade to libapache-mod-php4_4.3.10-18\n');
}
if (deb_check(prefix: 'libapache2-mod-php4', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package libapache2-mod-php4 is vulnerable in Debian 3.1.\nUpgrade to libapache2-mod-php4_4.3.10-18\n');
}
if (deb_check(prefix: 'php4', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4 is vulnerable in Debian 3.1.\nUpgrade to php4_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-cgi', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-cgi is vulnerable in Debian 3.1.\nUpgrade to php4-cgi_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-cli', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-cli is vulnerable in Debian 3.1.\nUpgrade to php4-cli_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-common', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-common is vulnerable in Debian 3.1.\nUpgrade to php4-common_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-curl', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-curl is vulnerable in Debian 3.1.\nUpgrade to php4-curl_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-dev', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-dev is vulnerable in Debian 3.1.\nUpgrade to php4-dev_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-domxml', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-domxml is vulnerable in Debian 3.1.\nUpgrade to php4-domxml_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-gd', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-gd is vulnerable in Debian 3.1.\nUpgrade to php4-gd_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-imap', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-imap is vulnerable in Debian 3.1.\nUpgrade to php4-imap_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-ldap', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-ldap is vulnerable in Debian 3.1.\nUpgrade to php4-ldap_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-mcal', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mcal is vulnerable in Debian 3.1.\nUpgrade to php4-mcal_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-mhash', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mhash is vulnerable in Debian 3.1.\nUpgrade to php4-mhash_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-mysql', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-mysql is vulnerable in Debian 3.1.\nUpgrade to php4-mysql_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-odbc', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-odbc is vulnerable in Debian 3.1.\nUpgrade to php4-odbc_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-pear', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-pear is vulnerable in Debian 3.1.\nUpgrade to php4-pear_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-recode', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-recode is vulnerable in Debian 3.1.\nUpgrade to php4-recode_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-snmp', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-snmp is vulnerable in Debian 3.1.\nUpgrade to php4-snmp_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-sybase', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-sybase is vulnerable in Debian 3.1.\nUpgrade to php4-sybase_4.3.10-18\n');
}
if (deb_check(prefix: 'php4-xslt', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4-xslt is vulnerable in Debian 3.1.\nUpgrade to php4-xslt_4.3.10-18\n');
}
if (deb_check(prefix: 'php4', release: '3.1', reference: '4.3.10-18')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package php4 is vulnerable in Debian sarge.\nUpgrade to php4_4.3.10-18\n');
}
if (w) { security_hole(port: 0, data: desc); }
