# This script was automatically generated from the dsa-1207
# Debian Security Advisory
# It is released under the Nessus Script Licence.
# Advisory is copyright 1997-2004 Software in the Public Interest, Inc.
# See http://www.debian.org/license
# DSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

desc = '
The phpmyadmin update in DSA 1207 introduced a regression. This update
corrects this flaw. For completeness, please find below the original
advisory text:
Several remote vulnerabilities have been discovered in phpMyAdmin, a
program to administrate MySQL over the web. The Common Vulnerabilities
and Exposures project identifies the following problems:
    CRLF injection vulnerability allows remote attackers to conduct
    HTTP response splitting attacks.
    Multiple cross-site scripting (XSS) vulnerabilities allow remote
    attackers to inject arbitrary web script or HTML via the (1) HTTP_HOST
    variable and (2) various scripts in the libraries directory that
    handle header generation.
    Multiple cross-site scripting (XSS) vulnerabilities allow remote
    attackers to inject arbitrary web script or HTML via scripts in the
    themes directory.
    A cross-site scripting (XSS) vulnerability allows remote attackers
    to inject arbitrary web script or HTML via the db parameter of
    footer.inc.php.
    A remote attacker could overwrite internal variables through the
    _FILES global variable.
For the stable distribution (sarge) these problems have been fixed in
version 2.6.2-3sarge3.
For the upcoming stable release (etch) and unstable distribution (sid)
these problems have been fixed in version 2.9.0.3-1.
We recommend that you upgrade your phpmyadmin package.


Solution : http://www.debian.org/security/2006/dsa-1207
Risk factor : High';

if (description) {
 script_id(23656);
 script_version("$Revision: 1.1 $");
 script_xref(name: "DSA", value: "1207");
 script_cve_id("CVE-2005-3621", "CVE-2005-3665", "CVE-2006-1678", "CVE-2006-2418", "CVE-2006-5116");

 script_description(english: desc);
 script_copyright(english: "This script is (C) 2006 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[DSA1207] DSA-1207-2 phpmyadmin");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Debian Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/Debian/dpkg-l");
 script_summary(english: "DSA-1207-2 phpmyadmin");
 exit(0);
}

include("debian_package.inc");

w = 0;
if (deb_check(prefix: 'phpmyadmin', release: '3.1', reference: '2.6.2-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpmyadmin is vulnerable in Debian 3.1.\nUpgrade to phpmyadmin_2.6.2-3sarge3\n');
}
if (deb_check(prefix: 'phpmyadmin', release: '3.1', reference: '2.6.2-3sarge3')) {
 w ++;
 if (report_verbosity > 0) desc = strcat(desc, '\nThe package phpmyadmin is vulnerable in Debian sarge.\nUpgrade to phpmyadmin_2.6.2-3sarge3\n');
}
if (w) { security_hole(port: 0, data: desc); }
